#include "mbed.h"
#include "HIDScope.h"

AnalogIn    input1( A0 );
AnalogIn    input2( A1 );
AnalogIn    input3( A2 );
AnalogIn    input4( A3 );
AnalogIn    input5( A4 );
AnalogIn    input6( A5 );

DigitalOut  led(LED_GREEN);

HIDScope    scope(4);

Ticker      tick;

double x;
double y;

void readout()
    {
        double in1 = input1.read();
        double in2 = input2.read();
        double in3 = input3.read();
        double in4 = input4.read();
        double RL = input5.read();
        double LL = input6.read();
        
        double RA = in1+in2;
        double LA = in3+in4;
        
        if (RA < 0.5)
            {
                x = x;
            }
        else if (RA > 1.5)
            {
                x = x-0.001;
            }
        else
            {
                x = x+0.001;
            }
            
        if (LA < 0.5)
            {
                y = y;
            }
        else if (LA > 1.5)
            {
                y = y-0.001;
            }
        else
            {
                y = y+0.001;
            }
            
        
        scope.set(0, x); // x-value
        scope.set(1, y); // y-value
        scope.set(2, RL);
        scope.set(3, LL);
        
        scope.send();
        
        led = !led;
    }
    
int main()
{
    
    led = 1;
    
    x = 0;
    
    tick.attach(&readout, 0.002);
}