#ifndef _BIQUAD_H_
#define _BIQUAD_H_

#include "mbed.h"

class Biquad
{
public:
    ///Instantiate the biquad filter
    Biquad(void);

    /**Filters the given signal with the filter values.
    * @param u : double signal to filter
    * @param &v1 : double variable to store previous values
    * @param &v2 : double variable to store previous values
    * @param a1 : double filter coefficient a1
    * @param a1 : double filter coefficient a2
    * @param a1 : double filter coefficient b0
    * @param a1 : double filter coefficient b1
    * @param a1 : double filter coefficient b2
    * @return v : double filtered signal
    */
    double filter( double u, double &v1, double &v2, const double a1, const double a2,
                   const double b0, const double b1, const double b2 );
};
#endif