#include "mbed.h"
#include "MODSERIAL.h"
#include "QEI.h"
#include "math.h"
#include "HIDScope.h"
#include "Biquad.h"
 
DigitalOut green(LED_GREEN);
MODSERIAL pc(USBTX, USBRX);
///////////////////////////
// Hardware initialiseren//
///////////////////////////
//------------------------------------------------------------
//--------------------All sensors-----------------------------
//------------------------------------------------------------
//--------------------Encoders--------------------------------

QEI Encoder_L (D11, D10,NC, 32);  //D11 is poort A D10 is poort b
QEI Encoder_R (D13, D12,NC, 32); //D 13 is poort A 12 is poort b
const int SampleFrequency = 100;
const float pi = 3.141;
float Speed_L = 0.0;
const float AnglePerPulse = (2*pi)/4200;
double Position_L = 0.0;
double Position_R = 0.0;
double Previous_Position_L = 0.0;
double Previous_Position_R = 0.0;
float Signal_L = 2*pi;
//--------------------Analog---------------------------------
//-------------------Hidscope----------------------------------
HIDScope scope(2); // Sending two sets of data

//-------------------Interrupts-------------------------------

//------------------Tickers------------------------------------

Ticker Measure; // ticker for data mesuaring
//------------------------------------------------------------
//--------------------All Motors----------------------------
//------------------------------------------------------------

//-------------------- Motor Links----------------------------
DigitalOut M_L_D(D4); //Richting motor links
PwmOut     M_L_S(D5); //Speed motor links
DigitalOut M_R_D(D7); //Richting motor Rechts
PwmOut     M_R_S(D6); //Speed motor Rechts

//--------------------------------------------------------------
//-----------------------Functions------------------------------
//--------------------------------------------------------------
bool Go_Flag = true;
bool Cont_Flag = true;
float Error = 0;
void SetFlag(){
    Go_Flag = true;
    Cont_Flag = true;
    }
//-----------------------Interrupts-----------------------------
void Boot(){ 
    Encoder_L.reset();
    Encoder_R.reset();
    }
      
void Information(){
    
//---------------------Motor Data-----------------------------------------------
    if (Go_Flag == true){
        //Position in Radials:
        Previous_Position_L = Position_L;
        Previous_Position_R = Position_R;
        Position_L = Encoder_L.getPulses()*AnglePerPulse+Previous_Position_L;
        Position_R = Encoder_R.getPulses()*AnglePerPulse+Previous_Position_R;
    //---------------------Sending data---------------------------------------------
        
        Speed_L = (Position_L-Previous_Position_L)*SampleFrequency;

        Encoder_L.reset();
        Encoder_R.reset();
        scope.set(0,Speed_L); //Sending motor left speed
        scope.set(1,Position_L); //sending random value
        scope.send();
        Go_Flag = false;
        }
    }
void Controller(){//onstabiele gain regelaar
    if (Cont_Flag == true ){
        Error = Signal_L-Position_L ;
        if (Error >=0){
            M_L_D = 1;
            M_L_S = fabs(Error);
            }  else {
            M_L_D = 0;
            M_L_S = fabs(Error);
            }
        Cont_Flag = false;
        }
    }
//-----------------------Encoders-----------------------------------------------

int main()
{
//---------------------Setting constants and system booting--------------------
    pc.baud(115200);
    pc.printf("\r\n**BOARD RESET**\r\n");
    Boot();
    Measure.attach(SetFlag, 1.0/SampleFrequency);     
    M_L_D = 1;
//------------------------Main While Loop--------------------------------------
    while (true) {  
    Information();
    Controller();
       // control= pc.getc();     
    }
}