#include "mbed.h"
#include "HIDScope.h"
#include "biquadFilter.h"        // Require the HIDScope library
#include "MODSERIAL.h"
#include "QEI.h"
//Define objects
AnalogIn    emg(A0); //Analog of EMG input
Ticker      sample_timer;
Ticker      motor_timer;
Ticker      cal_timer;
HIDScope    scope(2);        // Instantize a 2-channel HIDScope object
DigitalIn button1(PTA4);//test button for starting motor 1
DigitalOut led1(LED_RED);
DigitalOut led2(LED_BLUE);
DigitalOut led3(LED_GREEN);
MODSERIAL pc(USBTX,USBRX);
// motor objects
QEI motor1(D13,D12,NC, 624);//encoder for motor 1
QEI motor2(D11,D10,NC, 624);//encoder for motor 2
DigitalOut direction1(D7);//direction input for motor 1
DigitalOut direction2(D4);//direction input for motor 2
PwmOut speed1(D6);//speed input for motor 1
PwmOut speed2(D5);//speed input for motor 2

/*The biquad filters required to transform the EMG signal into an usable signal*/
biquadFilter filterhigh1(-1.1430, 0.4128, 0.6389, -1.2779, 0.6389);
biquadFilter filterlow1(1.9556, 0.9565, 0.9780, 1.9561, 0.9780);
biquadFilter notch(-1.1978e-16, 0.9561, 0.9780, -1.1978e-16, 0.9780);
biquadFilter filterlow2(-1.9645, 0.9651, 1.5515e-4, 3.1030e-4, 1.5515e-4);
double emg_value;
double signalpart1;
double signalpart2;
double signalpart3;
double signalpart4;
double signalfinal;
double onoffsignal;
double maxcal=0;        
bool calyes=0;
bool motor1_dir=0;//set the direction of motor 1
bool motor2_dir = 0;//set the direction of motor 1

float cycle = 0.3;//define the speed of the motor
   bool motor1_on = 1;//set the on variable of motor 1
   bool motor2_on =1;//set the on variable of motor 2
   int n1=1;//numeric conditions to determine if the speed needs to be increased
   int n2=1;

void changedirmotor1(){
        motor1_dir = !motor1_dir;//code for changing direction of motor 1
        }
void changedirmotor2(){
        motor2_dir = !motor2_dir;//code for changing direction of motor 2
        }        

/* 
 */
void filter(){
        if(calyes==1){
        emg_value = emg.read();//read the emg value from the elektrodes
        signalpart1 = notch.step(emg_value);//Highpass filter for removing offset and artifacts
        signalpart2 = filterhigh1.step(signalpart1);//rectify the filtered signal
        signalpart3 = abs(signalpart2);//low pass filter to envelope the emg
        signalpart4 = filterlow1.step(signalpart3);//notch filter to remove 50Hz signal
        signalfinal = filterlow2.step(signalpart4);//2nd low pass filter to envelope the emg
        onoffsignal=signalfinal/maxcal;//divide the emg signal by the max EMG to calibrate the signal per person
        scope.set(0,emg_value);//set emg signal to scope in channel 1
        scope.set(1,onoffsignal);//set filtered signal to scope in channel 2
    scope.send();//send the signals to the scope
        //pc.printf("emg signal %f, filtered signal %f \n",emg_value,onoffsignal);
}
}
void checkmotor(){//check the normalized signal and set actions if a threshold is passed
    if(calyes==1){
    if(onoffsignal >= 0.5){
                 led1.write(0);
                 led2.write(1);
            while(n1 == 1){
                changedirmotor1();
                speed1.write(cycle);//write speed only on first run through the loop
                direction1.write(motor1_dir);//turn motor CCW or CW 
                  
                n1=0;
                  }
             }
    else if(onoffsignal<=0.25){
             led1.write(1);
             led2.write(0);
             
            while(n1==0){//check if the first run was done
                 speed1.write(0);//if so set speed to 0 and reset the run counter
                 n1=1;
             }
            }
    
        }
}

void calibri(){//calibration function
    if(button1.read()==false){
        for(int n =0; n<5000;n++){//read for 5000 samples as calibration
            emg_value = emg.read();//read the emg value from the electrodes
            signalpart1 = notch.step(emg_value);//Highpass filter for removing offset and artifacts
            signalpart2 = filterhigh1.step(signalpart1);//rectify the filtered signal
            signalpart3 = abs(signalpart2);//low pass filter to envelope the emg
            signalpart4 = filterlow1.step(signalpart3);//notch filter to remove 50Hz signal
            signalfinal = filterlow2.step(signalpart4);//2nd low pass filter to envelope the emg
            double signalmeasure = signalfinal;
            if (signalmeasure > maxcal){//determine what the highest reachable emg signal is
                maxcal = signalmeasure;
                }
            }
        calyes=1;
    }  
    }
int main()
{
    pc.baud(115200);
    led1.write(1);
    led2.write(1);
   
        sample_timer.attach(&filter, 0.002);//continously execute the EMG reader and filter
        motor_timer.attach(&checkmotor, 0.002);//continously execute the motor controller
        cal_timer.attach(&calibri, 0.002);//ticker to check if motor is being calibrated
        

while(1){
 //random while loop to keep system going                                                 
}     
}