#include "mbed.h"
#include "C12832.h"
#include "Sht31.h"

C12832 lcd(p5,p7,p6,p8,p11);
Sht31 sht31(I2C_SDA, I2C_SCL);
DigitalOut Heater(LED1);
DigitalOut airconditioner(LED2);
DigitalOut Humidifier(LED3);
DigitalOut Dehumidifier(LED4);


int main() {
    
    printf("Set the temperature above 25 degrees to trigger the warning LED\n");
    
    while(1) {
        lcd.cls();

        float temp = sht31.readTemperature();
        float humidity = sht31.readHumidity();

        lcd.locate(0,0);
        lcd.printf("Temperature: %.2f C", temp);
        lcd.locate(64,0);
        lcd.printf("Humidity: %.2f %%", humidity);
        lcd.locate(0,10);
        lcd.printf("Heater Room UP");
        lcd.locate(0,10);
        lcd.printf("Cooling Room Down");
        lcd.locate(0,20);
        lcd.printf("Increasing Humidity");
        lcd.locate(0,20);
        lcd.printf("Decreasing Humidity");
        
        // turn on LED if the temperature is above 25 degrees
        Heater = temp > 25.0f;

        wait(0.5f);
        
        Humidifier = 1; //humidifier will be on,LED3 blink
        wait(0.8);
        Humidifier = 0; //humidifier will be off,LED3 close
        wait(0.8);
        Dehumidifier = 1;
        wait(0.8);
        Dehumidifier = 0;
        wait(0.8);
    }
}
