#include "mbed.h"
#include "MODSERIAL.h"

//Define objects
AnalogIn    emg0(PTB0); //Analog input
DigitalOut      blue(LED_BLUE); //Digi output
Ticker timer;
MODSERIAL pc(USBTX,USBRX);

 double numh1,numh2,denh2; //High pass filter coeffs
 double numl1,numl2,numl3,numl4,denl2,denl3,denl4; //Low pass filter coeffs
 double numn1,numn2,numn3,denn2,denn3; //Notch filter coeffs
 double raw,xbr,x1br,hbr,h1br,h2br,nbr,n1br,n2br,yabsbr,yabs1br,yabs2br,yabs3br,lbr,l1br,l2br,l3br,signal,emggain; //Signal intermediates

void looper()
{
    /*put raw emg value both in red and in emg_value*/
    blue = raw = emg0.read();
        xbr=(raw-0.5)*2.0;
        hbr=xbr*numh1+x1br*numh2-h1br*denh2;
        nbr=hbr*numn1+h1br*numn2+h2br*numn3-n1br*denn2-n2br*denn3;
        yabsbr=abs(nbr);
        lbr=yabsbr*numl1+yabs1br*numl2+yabs2br*numl3+yabs3br*numl4-l1br*denl2-l2br*denl3-l3br*denl4;
        x1br=xbr;
        h2br=h1br;
        h1br=hbr;
        n2br=n1br;
        n1br=nbr;
        yabs3br=yabs2br;
        yabs2br=yabs1br;
        yabs1br=yabsbr;
        l3br=l2br;
        l2br=l1br;
        l1br=lbr;
        signal=lbr*emggain;
    /*send value to PC. use 6 digits after decimal sign*/
    pc.printf("%f \n",signal);
    /**When not using the LED, the above could also have been done this way:
    * pc.printf("%.6\n", emg0.read());
    */
}

int main()

{  
x1br=0;
h2br=0;
h1br=0;
n2br=0;
n1br=0;
yabs3br=0;
yabs2br=0;
yabs1br=0;
l3br=0;
l2br=0;
l1br=0;
    
    //Filtercoëfficienten.
    //High pass, 30Hz, 1e orde, 4 ms.
    numh1=0.839799649112263;
    numh2=-0.839799649112263;
    //denh1=1;
    denh2=-0.679599298224526;
    
    //Notch filter, 50 Hz, -35 dB
    numn1=0.991103635646810;
    numn2=-1.603639368850131;
    numn3=0.991103635646810;
    //denn1=1;
    denn2=-1.603639368850131;
    denn3=0.982207271293620;

    //Low pass, 3 Hz, 3e orde, 4 ms.
    numl1=0.000001935454105;
    numl2=0.000005806362315;
    numl3=0.000005806362315;
    numl4=0.000001935454105;
    //denl1=1;
    denl2=-2.949735839706348;
    denl3=2.900726988355438;
    denl4=-0.950975665016249;    
    //emg gain
    emggain=5;

    /*setup baudrate. Choose the same in your program on PC side*/
    pc.baud(115200);
    /*set the period for the PWM to the red LED*/
    //red.period_ms(2);
    /**Here you attach the 'void looper(void)' function to the Ticker object
    * The looper() function will be called every 0.001 seconds.
    * Please mind that the parentheses after looper are omitted when using attach.
    */
    timer.attach(looper, 0.001);
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}