/// SPDX-License-Indentifier: Apache-2.0
/// Copyright: 2020+ Philippe Coval <https://purl.org/rzr/>
/// URL: https://os.mbed.com/users/rzrfreefr/code/rzr-example-mbed/

#include "Utils.h"

//https://github.com/ARMmbed/mbed-os/blob/c6094f7b36dc0e90a6a7271870333fbba475286c/drivers/usb/source/USBKeyboard.cpp
#define REPORT_ID_KEYBOARD 1

bool Utils::keyboard_key_code(USBKeyboard& usb,
                              unsigned char const key,
                              unsigned char const modifier,
                              unsigned int delay)
{
    HID_REPORT report;

    report.data[0] = REPORT_ID_KEYBOARD;
    report.data[1] = modifier;
    report.data[2] = 0;
    //report.data[3] = usb.keymap[key].usage;
    report.data[3] = key;

    report.data[4] = 0;
    report.data[5] = 0;
    report.data[6] = 0;
    report.data[7] = 0;
    report.data[8] = 0;

    report.length = 9;

    if (!usb.send(&report)) {
        return false;
    }
    if (delay) { 
      ThisThread::sleep_for(delay);
    }
    report.data[1] = 0;
    report.data[3] = 0;

    if (!usb.send(&report)) {
        return false;
    }
    return true;
}
