#include "Led_Lcd.h"

LedLcd::LedLcd(unsigned char ucColumn){
    Clear(LCD_COLOR_BLACK);
    SetFont(&Font24);
    SetTextColor(LCD_COLOR_GREEN);
    ucColIndex = ucColumn;
    for(unsigned char ucBtnIndex = 0; ucBtnIndex < 4; ucBtnIndex++){
         DrawRect((ucColIndex * 80), (ucBtnIndex * 80), 80, 80);   
    }
}

void LedLcd::On(unsigned char ucGreenBtn){
    SetBackColor(LCD_COLOR_RED);
    for(unsigned char ucBtnIndex = 0; ucBtnIndex < 4; ucBtnIndex++){
        if(ucBtnIndex == ucGreenBtn){
            SetTextColor(LCD_COLOR_GREEN);
        }
        else{
            SetTextColor(LCD_COLOR_BLUE);
        }        
        FillRect((ucColIndex * 80)+1, ((ucBtnIndex * 80) + 1), 78, 78);
        SetTextColor(LCD_COLOR_WHITE);
        char number[2] = {ucBtnIndex + 48, 0};
        DisplayStringAt((ucColIndex * 80), (ucBtnIndex * 80), (uint8_t *)number, LEFT_MODE);    
    }
}
