#pragma once

#include "mbed.h"

const float MIDR = 0.0f; // TODO
const float MIDL = 0.0f; // TODO

// IR Stuff
const int WARM_UP_US = 60;
const int COOL_DOWN_US = 60;

class IR {
public:
    IR();
    void update() volatile;

    float RF() volatile { return m_rf; };
    float LF() volatile { return m_lf; };
    float RS() volatile { return m_rs; };
    float LS() volatile { return m_ls; };
        
    float RS_error() volatile;
    float LS_error() volatile;
    
    void printValues() volatile;
private:
    float flash_ir(DigitalOut ir, AnalogIn rec) volatile;
    float read_ir(AnalogIn rec) volatile;

    float m_rf;
    float m_lf;
    float m_rs;
    float m_ls;
    
    float init_rf;
    float init_lf;
};
