#include "systick.h"
#include "mbed.h"
#include "globals.h"

void systickFunction() {
    // Update global counter
    millis++;
    mainController.update();
    
    // Update other sensors
    ir.update();
}

void Systick::start() {
     m_systicker.attach(&systickFunction, SYS_TICK_TIME);
}

void Systick::stop() {
     m_systicker.detach();
}

Systick::Systick() {
    // A little bit of magic; if you want to know why, ask Robert
    NVIC_SetPriority(TIM5_IRQn, 255);
}

void Systick::wait(float sec) {
    // Utility function: allows you to wait while using systick.
    int init = millis;
    
    float num_ticks = sec / SYS_TICK_TIME;

    while (millis - init < num_ticks)
        ;
}
