#include "globals.h"
#include "pins.h"
#include "beep.h"

/***
 * Driving stuff
 ***/
void test_drive_straight() {    
    systick.start();
    //motors.setRightPwm(0.1f);
    //motors.setLeftPwm(0.1f);
    while(1) {
        mainController.moveCells(100);
    }
}

/***
 * Assignment 2
 ***/

void basic_motor_movement() {
    motors.setRightPwm(0.15f);
    motors.setLeftPwm(0.15f);

    wait(3);
    
    motors.stop();
    
    wait(1);

    motors.stop();
    pc.printf("right: %d, left: %d\n", encoders.right(), encoders.left());

    
    motors.setRightPwm(-0.2f);
    motors.setLeftPwm(-0.2f);
    
    wait(3);
    motors.stop();

    // TODO: Turn
}

void read_encoders() {
    while (true) {
        encoders.printValues();
        wait(0.5);
    }
}

void test_systick() {
    systick.start();

    while (true) {
        wait(1);
        pc.printf("Current time (ms): %d\n", millis);
    }
}

void test_buzzer() {
    Beep buzzer(PB_14);
    
    for (int i=0; i < 5; i++) {
        buzzer.beep(1000, 1);
        wait(2);
    }
}

inline float flash(DigitalOut emit, AnalogIn recv) {
    float val;
    emit = 1;
    wait_us(60);
    val = recv.read();
    emit = 0;
    wait_us(60);
    
    return val;
}

void test_ir() {
    
    pc.printf("Testing IRs.\n");
    
    systick.start();
    
    while(1) {        
        //ir.update();
        pc.printf("millis: %d\t", millis);
        ir.printValues();
        
        wait(0.3);
    }
}