#include "ir.h"
#include "pins.h"
#include "globals.h"

AnalogIn rec_RF(DET_Rfront);
AnalogIn rec_LF(DET_Lfront);
//AnalogIn rec_RS(DET_Rside);
//AnalogIn rec_LS(DET_Lside);

DigitalOut ir_RF(IR_Rfront);
DigitalOut ir_LF(IR_Lfront);
//DigitalOut ir_RS(IR_Rside);
//DigitalOut ir_LS(IR_Lside);


///////
// IR class implementation
///////

IR::IR() {
    m_rf = 0;
    m_lf = 0;
    m_rs = 0;
    m_ls = 0;
}

/***
 * Assignment 4 START
 ***/

/***
 * Properly turn the IR's on, warm up receiver for WARM_UP_US,
 * read the value, cool down receivers for COOL_DOWN_US,
 * then turn off.
 ***/
float IR::flash_ir(DigitalOut ir, AnalogIn rec) volatile {
    ir = 1;
    wait_us(WARM_UP_US);
    float ret = read_ir(rec);
    ir = 0;
    wait_us(COOL_DOWN_US);
    
    return ret;
}

float IR::RS_error() volatile {
    // TODO

    if (RS() > MIDR) {
        //return RS_base() - RS();
        return 0;
    }
    else return 0;
}

float IR::LS_error() volatile {
    // TODO

    if (LS() > MIDL) {
        //return LS() - LS_base();
        return 0;
    }
    else return 0;
}

float IR::read_ir(AnalogIn rec) volatile {
    // Read an IR, averaging over 10 reads.
    int n = 10;
    float total = 0;
       
    for (int i = 0; i < n; i++) {
        total += rec.read();   
    }
    
    return total / n;
}

void IR::update() volatile {
    // Update all your IR readings.

    // Don't do any init because for some reason that doesn't work...
    m_rf = flash_ir(ir_RF, rec_RF); //- init_rf;
    m_lf = flash_ir(ir_LF, rec_LF); //- init_lf;
    
    //m_rs  = flash_ir(ir_RS, rec_RS); //- init_rs;
    //m_ls = flash_ir(ir_LS, rec_LS); //- init_ls;
}


void IR::printValues() volatile {
    // Utility: Use for diagnostics

    pc.printf("RF: %.3f\tLF: %.3f\tRS: %.3f\tLS: %.3f\n",
        m_rf, m_lf, m_rs, m_ls);
}