#include "encoders.h"
#include "pins.h"
#include "globals.h"
#include "mbed.h"
#include "QEI.h"

/***
 * Assignment 2
 * 
 * Import the QEI in order to have functioning encoders.
 ***/
QEI wheel_R(ENC_RB, ENC_RF, NC, 624, QEI::X4_ENCODING);
QEI wheel_L(ENC_LF, ENC_LB, NC, 624, QEI::X4_ENCODING);

///////
// Encoder class implementation
///////

Encoder::Encoder() {
    reset();
}

void Encoder::reset() volatile {
    m_countR = 0;
    m_countL = 0;
    wheel_R.reset();
    wheel_L.reset();
}

void Encoder::update() volatile {
    m_countR = wheel_R.getPulses();
    m_countL = wheel_L.getPulses();
}

int Encoder::right() volatile {
    return wheel_R.getPulses();
}

int Encoder::left() volatile {
    return wheel_L.getPulses();
}

void Encoder::printValues() volatile {
//    Serial pc(TX, RX);
    pc.printf("R: %d\tL: %d\n", right(), left());
}
