
    
 #ifndef MBED_IRM_H
 #define MBED_IRM_H

#include "mbed.h"
#include "interruptin_mod.h"
/** IRM2121  class, based on an InterruptIn pin, and a timer
 *  use RoboCup Junior Soccer to find PULSE BALL.
 
 
 * Example:
 * @code
 * // Set interrupt and read sensor.
 * #include "mbed.h"
 * #include "IRM2121.h"
 * IRM2121 IR(p21);
 * 
 * int main() {
 *     int length;
 
 *     while(1) {
 *  
 *        IR.Set();    
 *        wait_ms(20); //check _Busy 1 &_Valid 0 ....config just wait time.
 *        length = IR.Read();
 *     }
 * }
 * @endcode
 */
class IRM2121 {
  public:
    /** Create a IRM2121 object connected to the specified InterruptIn pin
    *
    * @param IRM_PIN InterruptIn pin to connect to 
    */
    IRM2121(PinName IRM_PIN);
    
    
     /** Set a IRM2121 Interrupt Pin 
      *
      * @param none
      */
    void Set(void);
    
    /** Read the result 
      *
      * @param none
      */
    unsigned long Read(void);
    
    /**
      * Check two flags( _Valid, _Busy )
      *
      * @param none
      */
    void ReturnVB(bool *valid, bool *busy);
    
    
  private:
    
    interruptin_mod    _event;
    Timer              _timer;

    bool _Flag;
    bool _Valid;
    bool _Busy;
    unsigned long _Time;
      
    void _Start(void);
    void _Stop (void);
    
  };
  
  #endif