/* mbed Ping Library respected Library !!
 *
 * make interruptin_mod by bousiya03
 * 
 */


#include "IRM2121.h"
#include "interruptin_mod.h"
#include "mbed.h"

IRM2121::IRM2121(PinName IRM_PIN)
        : _event(IRM_PIN), _timer()
{          


} 
        
void IRM2121::_Start(void)
{
    if(_Valid && _Busy ){
        
        _timer.start();
        _Time  = _timer.read_us();
        _Valid = false;  
        _Busy  = true; 
        _event.fall_disable(this,&IRM2121::_Start);
        _event.rise(this,&IRM2121::_Stop);  
    }
}

void IRM2121::_Stop(void)
{
    if(!_Valid && _Busy){ 
        _Valid = true;  // When it stops, update the time
        _Busy  = false;
        _Time  = _timer.read_us()-_Time;
        _event.rise_disable(this,&IRM2121::_Stop);
    }
}

void IRM2121::Set(void)
{
    _timer.reset();
    _Valid = true;
    _Busy = true;
    _event.fall(this,&IRM2121::_Start );
    
       
     
}

unsigned long IRM2121::Read(void)
// 0 means not valid.
{
    if(_Valid && !_Busy){ 
        _event.fall_disable(this,&IRM2121::_Start);
        _event.rise_disable(this,&IRM2121::_Stop);
        return _Time;
    }    
    
    _event.fall_disable(this,&IRM2121::_Start);
    _event.rise_disable(this,&IRM2121::_Stop);
    
    return 0;
}


void IRM2121::ReturnVB(bool *valid, bool *busy){
    //use after read_function. this is flag checker. 
    *valid = _Valid;
    *busy  = _Busy;
       
}