#include "mbed.h"
#include "common.h"

#define KEYCODE 0xAA
#define TX_CHECKCODE (tx_data[1]^tx_data[2]^tx_data[3]^tx_data[4]^tx_data[5]^tx_data[6]^tx_data[7]^tx_data[8]^tx_data[9])
#define RX_CHECKCODE (rx_data[1]^rx_data[2]^rx_data[3]^rx_data[4]^rx_data[5]^rx_data[6]^rx_data[7]^rx_data[8]^rx_data[9])
#define DATA_NUM 11
#define CHECK (DATA_NUM - 1)


extern Serial sensor;
extern Serial xbee;
extern Serial pc;

extern uint8_t ping[4];
extern uint8_t ir_min;
extern uint8_t ir_num;
extern uint8_t ir_main;
extern unsigned int compass;

int count;

void xbee_tx(){
    xbee.putc(1);
    
}
 
void xbee_rx(){
    if(xbee.readable()){
        count = xbee.getc();
    } else {
        count = 0;
    }
    //pc.printf("%d\n", count);
    
}


void micon_rx(){
    
    static uint8_t rx;
    static int rx_data[DATA_NUM];
    
    rx_data[rx] = sensor.getc();
    
    if(rx_data[0] == KEYCODE){
        rx++;
    }
    
    if(rx >= DATA_NUM){
        if(rx_data[CHECK] == RX_CHECKCODE){
            ir_min = rx_data[1];
            ir_num = rx_data[2];
            ping[FRONT] = rx_data[3];
            ping[LEFT] = rx_data[4];
            ping[BACK] = rx_data[5];
            ping[RIGHT] = rx_data[6];
            compass = rx_data[7] + rx_data[8];
            ir_main = rx_data[9];
            //pc.printf("compass: %d\n",compass);
            //pc.printf("ping0:%d\tping1:%d\tping2:%d\tping3:%d\n",ping[0],ping[1],ping[2],ping[3]);
            //pc.printf("ir_min:%d\tir_num:%d\tir_main:%d\n",ir_min,ir_num,ir_main);
            
        } 
     rx = 0;   
    }
    
    //pc.printf("%d\n", rx_data[rx]);
}
/*
void micon_tx(){
    
    static uint8_t tx;
    static uint8_t tx_data[DATA_NUM];
    
    if(tx >= DATA_NUM){
        tx_data[0] = KEYCODE;
        tx_data[1] = KEYCODE;
        tx_data[2] = KEYCODE;
        tx_data[3] = KEYCODE;
        tx_data[4] = KEYCODE;
        tx_data[5] = KEYCODE;
        tx_data[6] = KEYCODE;
        tx_data[7] = KEYCODE;
        tx_data[8] = KEYCODE;
        tx_data[9] = KEYCODE;
        tx_data[10] = KEYCODE;
        tx_data[11] = TX_CHECKCODE;
        
        tx = 0;
    }
    
    sensor.putc(tx_data[tx]);
    tx++;
}
*/