#include "mbed.h"
#include "Ping.h"

#define SYSAHBCLKDIV_Val      0x00000001        // Reset: 0x001
#define CLOCK_SETUP           1                  // デフォルト=1
#define SYSPLLCTRL_Val        0x00000023        // デフォルト=23 Reset: 0x000
#define SYSPLLCLKSEL_Val      0x00000001        // デフォルト=0  Reset: 0x000
#define MAINCLKSEL_Val        0x00000003        // デフォルト=3  Reset: 0x000


#define ADDRESS 0xA0
#define DATA_NUM 5

DigitalOut myled(LED1);
I2CSlave Tiny(dp5, dp27);
Ping Sensor(dp1,dp2);
Serial pc(USBTX, USBRX);

int main() {
    
    char Export[DATA_NUM]={0};
    uint8_t cycle=0;
    
    Tiny.address(ADDRESS);
    //Tiny.frequency(9600);
    
    while(1) {
        
        
        Sensor.Send();
        wait_ms(30);
        Export[cycle%DATA_NUM] = 0xAA;//Sensor.Read_cm();
        
        cycle++;
        
        switch(Tiny.receive()){
            
            case I2CSlave::ReadAddressed:
                 Tiny.write(Export, DATA_NUM); // Includes null char
                 break;
            case I2CSlave::WriteGeneral:
                 break;
            case I2CSlave::WriteAddressed:
                 break;
        }
        
    }
}
