/*
超音波を参考にした

*/

#include "mbed.h"
#define BREAKPT_IR 833
#define ERROR_IR 0xFFF
//#define OVERLINE_IR 46
#define ALL_IR 1
volatile unsigned int ave[ALL_IR] = {0};
Serial pc(USBTX,USBRX);//tx,rx
Timer time_ir;
PinName num_ir[ALL_IR] = {p21/*,p22,p23,p24,p25,p26,p27,p28,p29,p30*/};

unsigned int moving_ave(int num,unsigned int data){
    static unsigned int sum[ALL_IR] = {0};
    static unsigned int temp[ALL_IR][10] = {{0}};
    //static unsigned int ave[ALL_IR] = {0};
    sum[num] -= temp[num][9];
    sum[num] += data;
    temp[num][9] = temp[num][8];
    temp[num][8] = temp[num][7];
    temp[num][7] = temp[num][6];
    temp[num][6] = temp[num][5];
    temp[num][5] = temp[num][4];
    temp[num][4] = temp[num][3];
    temp[num][3] = temp[num][2];
    temp[num][2] = temp[num][1];
    temp[num][1] = temp[num][0];
    temp[num][0] = data;
    ave[num] = sum[num]/100;
    
    /*if(ave[num] >= OVERLINE_IR){
        ave[num] = 0;
    }*/
    return ave[num];
       
}
unsigned int ir_function (int num){
    DigitalIn sensor_ir(num_ir[num]);
    int flag = 0;
    unsigned int memory = 0;
    unsigned int temp = 0;   
    flag = 1;
    time_ir.start();
    if((sensor_ir)){
        while((sensor_ir)){
            if(time_ir.read_us() >= BREAKPT_IR){
                flag = 0;
                break;
            }
        }
    }
    time_ir.stop();
    time_ir.reset();
    if(flag){
        time_ir.start();
        while(!sensor_ir){//!
            if(time_ir.read_us() >= BREAKPT_IR){
                break;
            }
        }
        memory = time_ir.read_us();
        while(1){
            if(!sensor_ir){
                temp = (time_ir.read_us() - memory);
                time_ir.stop();
                time_ir.reset();
                wait(0.01);
                return temp;
                
            }
        }
    }else{//not found
    
    }
    time_ir.stop();
    time_ir.reset();
    return ERROR_IR;
}

int main() {
    int num = 0;
    unsigned int hangar[ALL_IR] = {0};
    while(1) {
       
        hangar[num] = moving_ave(num ,ir_function(num));
       
        pc.printf("han[%d]=%d ",num, hangar[num]);
        num++;
        if(num >= ALL_IR){
            num = 0;
            putchar('\n');
        }
    }
}
