 #include "mbed.h"
 #include "ak8963.h"
// #include "I2C.h"
 
 #define I2C_SPEED_100KHZ    100000
 #define I2C_SPEED_400KHZ    400000

// Creates an instance of I2C
I2C connection(I2C_SDA, I2C_SCL);

AK8963::Status status8963;

    
 int main() {

     
     
     connection.frequency(I2C_SPEED_100KHZ);
     // Creates an instance of AK8963
     AK8963 ak8963(&connection, AK8963::SLAVE_ADDR_1);
     
     if(ak8963.checkConnection() == AK8963::SUCCESS) {
         
         printf("Everything is fine with I2c connection\n");
     }
     // Puts the device into continuous measurement mode.
     if(ak8963.setOperationMode(AK8963::MODE_CONTINUOUS_1) == AK8963::SUCCESS) {
         
         printf("Everything is fine with ak mode operation set\n");
     }
     

     
     
      while(true) {
         // checks DRDY
         
         status8963 = ak8963.isDataReady();
         if (status8963 == AK8963::NOT_DATA_READY) 
            printf("Data not ready \n");
         else if (status8963 == AK8963::DATA_READY)
            printf("Data ready \n"); 
            
         if (status8963 == AK8963::DATA_READY) {

             AK8963::MagneticVector mag = { -1 , -1 , -1 , false};
             ak8963.getMagneticVector(&mag);
             // You may use serial output to see data.
             printf("%d,%5.1f,%5.1f,%5.1f\n",
             mag.isOverflow,
             mag.mx, mag.my, mag.mz);
         }
 
     }
 }