//メインプログラム・UARTコマンド受信
#include "mbed.h"
#include <cstdio>
#include "ColorSensor.h"

#define SirialComSpeed 38400        //シリアル通信のBPS設定
#define I2Caddr 0x2A                //I2Cのアドレス

RawSerial LedSerial(SERIAL_TX, SERIAL_RX);                  //シリアル通信
I2C ColorSensor(PB_9,PB_8);                                 //カラーセンサーのI2C設定(sda,scl)

//積分時間設定
//積分時間のベースとなる時間
//ベース時間×マニュアルタイミング時間で積分時間が決まる
int BaseTimeSelect = 0x00;              //ベース時間：0x00で175us,0x01で2.8ms,0x02で44.8ms,0x03で358.4ms
int ManualTime[2] = {0x01,0x1E};        //マニュアルタイミング時間の{上位2byte,下位2byte}：16進数
int waitTime = 300;                     //待ち時間、積分時間×4倍より長くする必要あり(ms)
                                        //待ち時間が積分時間に対して短すぎる場合、正しい値が取れない
                                        //※数字が変化しない場合は短すぎる可能性大

void CsMode::SensorMain()
{
    //周波数設定
    ColorSensor.frequency(100000);

    //送受信用変数
    char rcvData[8]= {0,0,0,0,0,0,0,0};
    char sendData[2]= {0,0};

    //アドレス設定
    int addr = I2Caddr << 1;               //送信用にI2Cのアドレスを上位に1bitシフトする
    
        //アドレス(addr)に送信,コントロールバイトを指定(0x00),ADCリセット、
        //スリープ解除+積分時間設定(0x80 | BaseTime)
        sendData[0] = 0x00;
        sendData[1] = 0x80 | BaseTimeSelect;
        int tmpVal = ColorSensor.write(addr,sendData,2);
        
        //カラーセンサーと通信できない場合はエラー終了
        if (tmpVal!=0){
            LedSerial.printf ("ColorSensor Communication Error!!!\r\n");
            return;
        }   

        //アドレス(addr)に送信,コントロールバイトを指定(0x00)
        //マニュアルモード+積分時間設定(0x04 | BaseTime)
        sendData[0] = 0x00;
        sendData[1] = 0x04 | BaseTimeSelect;
        ColorSensor.write(addr,sendData,2);

        //アドレス(addr)に送信,コントロールバイトを指定(0x01),積分時間の上位2Byte
        sendData[0] = 0x01;
        sendData[1] = ManualTime[0];
        ColorSensor.write(addr,sendData,2);

        //アドレス(addr)に送信,コントロールバイトを指定(0x02),積分時間の下位2Byte
        sendData[0] = 0x02;
        sendData[1] = ManualTime[1];
        ColorSensor.write(addr,sendData,2);

        //待機
        wait_ms(waitTime);

        //アドレス(addr)に送信,出力データバイトを指定(0x03)
        sendData[0] = 0x03;
        ColorSensor.write(addr,sendData,1);

        //デバイスに対し8Byteデータを要求
        //データは 赤上位,赤下位,緑上位,緑下位,青上位,青下位,赤外上位,赤外下位の順
        //rcvData配列に0から順に1Byteずつ格納されていく
        ColorSensor.read(addr,rcvData,8);

        //受信したデータを表示（1色につき2Byte）
        LedSerial.printf ("R:%02x%02x,G:%02x%02x,B:%02x%02x,IR:%02x%02x\r\n",
                                    rcvData[0],rcvData[1],rcvData[2],rcvData[3],rcvData[4],
                                    rcvData[5],rcvData[6],rcvData[7]);

        return;
}
