#include "mbed.h"
#include "NokiaLCD.h"
#include "RangeFinder.h"

NokiaLCD lcd(p5, p7, p8, p11, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
RangeFinder rf(p21, 10, 5800.0, 100000);
Serial xbee(p9, p10);
#define PI 3.141592653589793


int main() {
    char a = 0;
    float d; //0~0.5
    
    long double x = 0;
    long double y = 0;
    long double circle_deg;
    long double circle_rad;
    lcd.background(0x000000);
    lcd.cls();
    /*
    lcd.locate(0,0);
    lcd.printf("Xbee RX OUT");
    lcd.locate(0,2);
    lcd.printf(">");
    */
    while(true){
        /*
        if(xbee.readable()){
            a = xbee.getc(); //XBee read
            lcd.printf("%c", a);
        }
        */
        d = rf.read_m();
        if (d == -1.0)  {
            //pc.printf("Timeout Error.\n");   
        } else if (d > 5.0) {  
            // Seeed's sensor has a maximum range of 4m, it returns
            // something like 7m if the ultrasound pulse isn't reflected. 
            //pc.printf("No object within detection range.\n");
        } else  {
            /*
            pc.printf("Distance = %f cm.\n", d*100);
            xbee.printf("%f\n", d*100);
            lcd.locate(0,0);
            lcd.printf("Xbee RX OUT");
            lcd.locate(0,5);
            lcd.printf("%f cm", d*100);
            wait(0.5);
            */
            for(int width=55; width < 61; width = width + 2
                for(circle_deg=0; circle_deg <= d*720; circle_deg++) {
                    circle_rad = circle_deg * PI / 180;
                    x = 65 + cos(circle_rad)*width;
                    y = 65 - sin(circle_rad)*width;
                    lcd.pixel(x, y, 0x00FFFF);
                }
            }
            lcd.locate(2, 7);
            lcd.printf("%f m", d);
            wait(0.5);
            lcd.cls();
            
        }
    }
}
