#include "mbed.h"
#include "Servo.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include "RCS620S.h" //library for felica RCS620S(switch science)
#include <inttypes.h>
#include <string.h>

#define MAX_USER_NUMBER 40

TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7
Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card reader module
Servo myServo(p21); //port-21 = doorlock servo

InterruptIn int_p23(p23); //reg_button
InterruptIn int_doorbutton(p24); //door open/close analog control button
Serial serial(p9, p10);  //Felica read and write module

static char HEXSTRING[17] = "0123456789ABCDEF";
char *itoh(uint8_t val, char *ptr);

char userid[MAX_USER_NUMBER][18]; //userid read from SD
char regid[18]; //register id

char *format = "%s";
bool reg_button = false;
bool door_status;

int already_count = 0;
//int try_count = 0;

char *p_items; //used in loading userid from SDcard

DigitalOut serialready(LED1);
DigitalOut felicarwready(LED2);
DigitalOut door_status_led(LED3);
DigitalOut int_led(LED4);

DigitalOut felicaready(p25);
DigitalOut auth_ok(p26);
DigitalOut auth_ng(p27);
DigitalOut regready(p28);
DigitalOut error_led(p29);

class Watchdog { //watchdog timer
public:
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;
        uint32_t clk = SystemCoreClock / 16;
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;
        
        kick();
    }
    
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

Watchdog w;


//interrupt pin setup
void int_reg() {  //registering button's interrupt
    int_led = 1;
    reg_button = 1;
    regready = 1;
}


void logSetup(){ //log and userid setup and read again
    FILE *fp = fopen("/sd/rdoor/userlist.txt", "r"); //user list(in sd)
    FILE *fp2 = fopen("/sd/rdoor/log.txt", "a"); //logfile(in sd)
    if (fp2 == NULL) error("could not read LOGFILES\n");
    if (fp == NULL) error("could not read USERLIST\n");
    
    //load all userid saved in SDcard
    for (int ii=0; ii < MAX_USER_NUMBER; ii++) {
        p_items = fgets(userid[ii], 18, fp); //load userid(max.18 character) from fp
        strtok(userid[ii], "\n\0");  // change \n to \0 method
        if(p_items == NULL) break;
    }
    
    fclose(fp);
    fclose(fp2);
    pc.printf("File OK\n");
}


void openDoor(){ //opening door(move motor, refresh lcd, change door_status, led)
    lcd.cls();
    lcd.printf("-MOTOR DRIVING-");
    myServo = 0;
    lcd.cls();
    lcd.printf("-DOOR:OPENED-");
    door_status = true;
    door_status_led = 1;
}
void closeDoor(){ //closing door
    lcd.cls();
    lcd.printf("-MOTOR DRIVING");
    myServo = 1.0;
    lcd.cls();
    lcd.printf("-DOOR:CLOSED-");
    door_status = false;
    door_status_led = 0;
}
    
//interrupt pin setup    
void int_doorctrl() {  //doorcontrol button's interrupt
    if (door_status == true) {
        closeDoor();
        door_status = true;
        
    } else if (door_status == false) {
        openDoor();
        door_status = false;
        
    }
    door_status = !door_status;
    wait(2);
}


int main() {
    lcd.printf("Hello! \n RFID_doorlock\n");
    
    
    //first setup
    logSetup(); //load all userid from SD(must : connect SD card)
    closeDoor(); //at beginning, door_status is set up tp close(false)
    
    int_p23.rise(&int_reg);
    int_doorbutton.rise(&int_doorctrl); //interrupt pin setup
    
    
    //felica setup
    int ret;
    int loop;
    char idbuffer[17];
    char *hexid;

    serial.baud(115200);
    serialready = 1;
    
    ret = 0;
    RCS620S felica;   
    while (ret == 0) {
        wait(1);
        ret = felica.initDevice();
    }
    felicarwready = 1;
    pc.printf("Reader OK \n");  //Felica Reader loading finished
    
    
    //print all loaded USERID first.
    for (int x = 0; x <= MAX_USER_NUMBER; x++) {
        pc.printf("-%s \n", userid[x]);
    }
    
    
    
    //main routine
    while(1) {
        pc.printf("Please FeliCa Touch\n");
        felicaready = 1;
        
        //reading id of touched Felica card
        hexid = idbuffer + sizeof(idbuffer);        // hexid = buffer[ last of elements ];
        *--hexid = '\0';
        while (felica.polling(0xffff) == 0);
        felicarwready = 0;
        pc.printf(">idm: ");
        felicaready = 0;
        for (loop = 7; loop >= 0; loop--){
            hexid = itoh(felica.idm[loop], hexid);
        }
        pc.printf("%s \n", hexid); //print touched id
        
        
        /*cf.
            hexid : touched Felica ID
            regid : special ID used by registering method
            userid[] : registered ID read from SDcard
        */
        
        
        //authentication
        for (int i = 0; i <= MAX_USER_NUMBER; i++) {
            if (strcmp(hexid, userid[i]) == 0) { //hexid = userid[i]
                pc.printf(">Auth Succeeded\n");
                auth_ok = 1;
                if (door_status == true) { //if door is opened now... close door
                    closeDoor();
                    pc.printf(">close door by %s to %s(No.%d)\n", hexid, userid[i], i+1);
                    wait(1);
                    auth_ok = 0;
                    break;
                }
                if (door_status == false) { //if door is closed now... open door
                    openDoor();
                    pc.printf(">open door by %s to %s(No.%d)\n", hexid, userid[i], i+1);
                    wait(1);
                    auth_ok = 0;
                    break;
                }
            } else { //hexid &#65533;&#65533; userid[i]
                pc.printf(">Auth failed by %s to %s(No.%d)\n", hexid, userid[i], i+1);
                
                if (i == MAX_USER_NUMBER) {
                    pc.printf(">Auth Failed\n");
                    auth_ng = 1;
                    wait(1);
                    auth_ng = 0;
                }
            }
        }
        wait(1); //to avoid repeating auth of same card


        //register new user's card
        if (reg_button == true) {
            pc.printf("--register mode--\n");
            
            //read again USERLIST from SD
            FILE *fp = fopen("/sd/rdoor/userlist.txt", "a");
            if (fp == NULL) error("could not read USERLIST\n");
            
            //first, read and auth MASTER_ID
            pc.printf("Please Master Felica Card Touch\n");
            felicaready = 1;
            hexid = idbuffer + sizeof(idbuffer);
            *--hexid = '\0';
            while (felica.polling(0xffff) == 0);
            felicarwready = 0;
            pc.printf(">idm: ");
            felicaready = 0;
            for (loop = 7; loop >= 0; loop--){
                hexid = itoh(felica.idm[loop], hexid);
            }
            pc.printf("%s (MASTER)\n", hexid);
            wait(3);
            
            
            //first id = master id...
            if (strcmp(hexid, userid[0]) == 0) { 
                pc.printf(">Auth Succeeded\n");
                auth_ok = 1;
                auth_ng = 0;
                //next, read and register NEW_USER's_ID
                pc.printf("Please Felica of New_User Touch\n");
                felicaready = 1;
                
                //Felica auth(hexid = NEW_USER's_ID)
                hexid = idbuffer + sizeof(idbuffer);
                *--hexid = '\0';
                while (felica.polling(0xffff) == 0);
                felicarwready = 0;
                pc.printf(">idm: ");
                felicaready = 0;
                for (loop = 7; loop >= 0; loop--){
                    hexid = itoh(felica.idm[loop], hexid);
                }
                pc.printf("%s (NEW USER)\n", hexid);
                
                
                //to avoid registering same ID
                already_count = 0; //variable initialization 
                for (int i = 0; i <= MAX_USER_NUMBER; i++) {
                    if (strcmp(hexid, userid[i]) == 0) {    
                        //NEW_USER's_ID == userid[i]...  already_count++
                        already_count = already_count + 1;  
                        pc.printf(">%d(debug)\n", already_count);
                    }
                }
                
                
                //if already_count is over 0, the ID is ALREADY REGISTERED ID.
                if (already_count == 0) {
                    //registering
                    //first, add "\n" to the end of NEW_USER'S_ID(hexid) (hexid + "\n" = regid)
                    sprintf(regid, "%s\n", hexid); 
                    int ret = fputs(regid, fp); //writing to SD
                    if(ret == EOF) {
                           error("Userid writing error");
                           auth_ng = 1;
                           auth_ok = 0;
                           wait(2);
                    } else {
                           pc.printf("Registering was completed\n");
                           auth_ok = 1;
                           auth_ng = 0;
                           wait(2);
                    }
                } else if(already_count > 0) {
                    pc.printf("Sorry, this is already registered ID\n");
                    auth_ng = 1;
                    auth_ok = 0;
                    wait(2);
                } else {
                    pc.printf("Error\n");
                    auth_ng = 1;
                    auth_ok = 0;
                    wait(2);
                }

                fclose(fp);
                
                
                //read userid from SD and setup userid list again.
                logSetup();
                //printing userid again.
                for (int xx = 0; xx <= MAX_USER_NUMBER; xx++) {
                    pc.printf("-%s \n", userid[xx]);
                }
                
                
                //if registering NEW_USER's_ID was completed successfully...
                // reg_button_flag : down
                reg_button = false;
                int_led = 0;
                
            } else {
                //first id &#65533;&#65533; master id... restart.
                pc.printf(">Auth Failed\n");
                pc.printf("Sorry, you aren't allowed to use register mode\n");
                auth_ok = 0;
                auth_ng = 1;
                wait(2);
                
            }
        regready = 0;
        }
    auth_ok = 0;
    auth_ng = 0;
    felicaready = 0;   
    }
}

//used by Felica
char *itoh(uint8_t val, char *ptr) {
    *--ptr = HEXSTRING[(val % 16)];     // (val & 0x0f)
    val /= 16;                          // val = val >> 4;
    *--ptr = HEXSTRING[(val % 16)];     // (val & 0x0f)
    return(ptr);
}
