/*
 *author Ryosuke Yumoto
 */
#ifndef ADNS3080_H
#define ADNS3080_H

#include "mbed.h"

//Register map
#define ADNS3080_PRODUCT_ID             0x00
#define ADNS3080_REVISION_ID            0x01
#define ADNS3080_MOTION                 0x02
#define ADNS3080_DELTA_X                0x03
#define ADNS3080_DELTA_Y                0x04
#define ADNS3080_SQUAL                  0x05
#define ADNS3080_PIXEL_SUM              0x06
#define ADNS3080_MAXIMUM_PIXEL          0x07
#define ADNS3080_CONFIGURATION_BITS     0x0a
#define ADNS3080_EXTENDED_CONFIG        0x0b
#define ADNS3080_DATA_OUT_LOWER         0x0c
#define ADNS3080_DATA_OUT_UPPER         0x0d
#define ADNS3080_SHUTTER_LOWER          0x0e
#define ADNS3080_SHUTTER_UPPER          0x0f
#define ADNS3080_FRAME_PERIOD_LOWER     0x10
#define ADNS3080_FRAME_PERIOD_UPPER     0x11
#define ADNS3080_MOTION_CLEAR           0x12
#define ADNS3080_FRAME_CAPTURE          0x13
#define ADNS3080_SROM_ENABLE            0x14
#define ADNS3080_FRAME_PERIOD_MAX_BOUND_LOWER   0x19
#define ADNS3080_FRAME_PERIOD_MAX_BOUND_UPPER   0x1a
#define ADNS3080_FRAME_PERIOD_MIN_BOUND_LOWER   0x1b
#define ADNS3080_FRAME_PERIOD_MIN_BOUND_UPPER   0x1c
#define ADNS3080_SHUTTER_MAX_BOUND_LOWER        0x1d
#define ADNS3080_SHUTTER_MAX_BOUND_UPPER        0x1e
#define ADNS3080_SROM_ID                0x1f
#define ADNS3080_OBSERVATION            0x3d
#define ADNS3080_INVERSE_PRODUCT_ID     0x3f
#define ADNS3080_PIXEL_BURST            0x40
#define ADNS3080_MOTION_BURST           0x50
#define ADNS3080_SROM_LOAD              0x60

#define ADNS3080_SPI_READ   0x00
#define ADNS3080_SPI_WRITE  0x80



class ADNS3080{
    public:
    
    ADNS3080(PinName mosi, PinName miso, PinName sck, PinName cs);
    
    int getProdID(void);
    int getRevID(void);
    int getMotion(void);
    signed char getDelta_X(void);
    signed char getDelta_Y(void);
    unsigned int getSQUAL(void);
    unsigned short getPixel_sum(void);
    char getMax_Pixel(void);
    int getConfiguration_bits(void);
    void setConfiguration_bits(char configuration);
    int getExtended_config(void);
    void setExtended_config(char extended_config);
/*
    short getData_Out(void);
    unsigned int getShutter(void);
    unsigned int getFrame_Period(void);
    void Motion_Clear(void);
*/
    
    int getInverProdID(void);
    
    private:
    
    SPI        spi_;
    DigitalOut nCS_;
    
    int ReadRegister(int address);
    
    void WriteRegister(int address, char data);
};

#endif