/*
 *author Ryosuke Yumoto
 */
#include "ADNS3080.h"

ADNS3080::ADNS3080(PinName mosi,
                   PinName miso,
                   PinName sck,
                   PinName cs) : spi_(mosi, miso, sck), nCS_(cs){
    
    spi_.frequency(2000000);
    spi_.format(8, 3);
    
    nCS_=1;
    
    wait_us(500);
    
}
//
int ADNS3080::getProdID(void) {
    
    return ReadRegister(ADNS3080_PRODUCT_ID);
    
}

int ADNS3080::getRevID(void) {
    
    return ReadRegister(ADNS3080_REVISION_ID);
    
}

int ADNS3080::getMotion(void) {
    
    return ReadRegister(ADNS3080_MOTION);
    
}

signed char ADNS3080::getDelta_X(void) {
    
    return ReadRegister(ADNS3080_DELTA_X);
    
}

signed char ADNS3080::getDelta_Y(void) {
    
    return ReadRegister(ADNS3080_DELTA_Y);
    
}

unsigned int ADNS3080::getSQUAL(void) {
    
    return ReadRegister(ADNS3080_SQUAL);
    
}

unsigned short ADNS3080::getPixel_sum(void) {
    
    return ReadRegister(ADNS3080_PIXEL_SUM);    
    
}

char ADNS3080::getMax_Pixel(void) {

    return ReadRegister(ADNS3080_MAXIMUM_PIXEL);
        
}

int ADNS3080::getConfiguration_bits(void){

    return ReadRegister(ADNS3080_CONFIGURATION_BITS);

}

void ADNS3080::setConfiguration_bits(char configuration){

    WriteRegister(ADNS3080_CONFIGURATION_BITS, configuration);

}

int ADNS3080::getExtended_config(void){
    
    return ReadRegister(ADNS3080_EXTENDED_CONFIG);   

}
void ADNS3080::setExtended_config(char extended_config){
    
    WriteRegister(ADNS3080_EXTENDED_CONFIG, extended_config);
    
}

/*
short getData_Out(void){

    ReadRegister(ADNS3080_DATA_OUT_UPPER);
    ReadRegister(ADNS3080_DATA_OUT_LOWER);    

}
unsigned int getShutter(void);
unsigned int getFrame_Period(void);
void Motion_Clear(void);
*/

int ADNS3080::getInverProdID(void) {
    
    return ReadRegister(ADNS3080_INVERSE_PRODUCT_ID);
    
}

int ADNS3080::ReadRegister(int address) {
    
    int tx = (ADNS3080_SPI_READ | address);
    int rx = 0;
    
    nCS_=0;
    
    spi_.write(tx);
    wait_us(50);
    rx = spi_.write(0x00);
    nCS_ = 1;
    
    return rx;
}

void ADNS3080::WriteRegister(int address, char data) {
    
    int tx = ( ADNS3080_SPI_WRITE | address);
    
    nCS_=0;
    spi_.write(tx);
    spi_.write(data);
    
    nCS_=1;
    
}