#include "mbed.h"

#define UART_TRACE  (1)

SPISlave spiS(D11, D12, D13, A2); // mosi, miso, sclk, ssel

int main()
{
    printf("SPISlave Test\r\n");
    
    spiS.format(8, 0);
    spiS.frequency(1000000);
    
    uint8_t pdata = 0;
    
    for (;;) {
        if (spiS.receive()) {
            uint8_t rdata = spiS.read();
            
            
            #if (UART_TRACE)
            printf("Slave: rdata:%d", rdata);
            
            uint8_t err = rdata - pdata;
            if (err != 1) {
                printf(" err: %d", err);
            }
            
            printf("\r\n");
            #endif
            
            pdata = rdata;
            
            uint8_t sdata = rdata;
            spiS.reply(sdata);
        } 
    }
}
