#include "mbed.h"
#include "VoltageMonitor.h"

#define UART_TRACE  (1)

#define VDD (3.33f)
#define LO  (2.4f)
#define HI  (2.7f)

AnalogIn Ain0(A0);
AnalogIn Ain1(A1);

DigitalOut PowerLed(D2);

VoltageMonitor VMon(&Ain1, VDD, LO, HI, &PowerLed);

int main()
{
    printf("\r\nVoltage Monitor Class Test.\r\n");
    
    while (1) {
        int st = VMon.check();
        float v_vdd = Ain0.read();
        
        printf("VDD: %fV\t", v_vdd * VDD);
        printf("VoltageMonitor Status: %d\r\n", st);
        
        wait(0.1);
    }
}
