/*
 * ST7565_SequencerDisplay.h
 *
 * 2016.08.13
 *
 */
#ifndef _ST7565_SEQUENCE_DISPLAY_H_
#define _ST7565_SEQUENCE_DISPLAY_H_

#define DISPLAY_PARAMS_ON_LCD   (0)

#include "mbed.h"
#include "SequencerDisplay.h"
#include "st7565LCD.h"

class ST7565_SequencerDisplay : public SequencerDisplay {
public:
    ST7565_SequencerDisplay(ST7565* _gLCD, Sequence* _sequences, int _sequenceNum) :
        SequencerDisplay(_sequences, _sequenceNum),
        gLCD(_gLCD),
        runningStep(0) {};
        
protected:    
    void drawRunningStep(int step) {
        gLCD->fillrect(step * 7, 3, 8, 2, 1);
    }
    
    void drawSequenceGrid(int step) {
        int x, y;
        int i;
        
        // Step Indicator Grid
        for (x = 0; x <= 16; x++) {
            gLCD->drawline(x * 7, 0, x * 7, 2, 1);
        }
        for (y = 0; y <= 1; y++) {
            gLCD->drawline(0, y * 2, 112, y * 2, 1);
        }

        gLCD->fillrect(step * 7, 1, 7, 1, 1);

        // Sequence Grid
        for (x = 0; x <= 16; x++) {
            gLCD->drawline(x * 7, 5, x * 7, 57, 1);
        }
        for (y = 0; y <= 13; y++) {
            gLCD->drawline(0, y * 4 + 5, 112, y * 4 + 5, 1);
        }
        
        for (i = 0; i < 16; i++) {
            int noteOctave = (sequences[i].getPitch() / 12) - (Sequence::getBaseNoteNumber() / 12);
            int pitchInOctave = sequences[i].getPitch() % 12;   // 表示中のOctave内のPitch
            // Octave内の12音階とOctave+1のPitch=0を表示
            if (this->getOctave() == noteOctave) {
                int pitchRev = 12 - pitchInOctave;  // Pitchの位置をGridの下から上に変換
                gLCD->fillrect(i * 7, pitchRev * 4 + 5, 7, 4, 1);
            }
            if ((this->getOctave() + 1 == noteOctave) && (pitchInOctave == 0)) {
                gLCD->fillrect(i * 7, 5, 7, 4, 1);
            }
        }
    }
        
    void drawNoteGrid() {
        int x, i;
        // NoteOn & Tie Grid
        for (x = 0; x <= 16; x++) {
            gLCD->drawline(x * 7, 57, x * 7, 63, 1);
        }
        gLCD->drawline(0, 63, 112, 63, 1);
        
        for (i = 0; i < 16; i++) {
            if (sequences[i].isNoteOn()) {
                if (sequences[i].isAccent() && sequences[i].isTie()) {
                    gLCD->fillrect(i * 7, 57, 7, 6, 1);
                } else {
                    gLCD->fillrect(i * 7, 59, 5, 4, 1);
                    if (sequences[i].isAccent()) {
                        gLCD->fillrect(i * 7, 57, 5, 4, 1);
                    }
                    if (sequences[i].isTie()) {
                        gLCD->fillrect(i * 7 + 5, 59, 2, 4, 1);
                    }
                }
            }
        }
    }
    
    void drawOctave() {
        char buff[32];
        sprintf(buff, "%2d", this->getOctave());
        gLCD->drawstring(115, 0, "OC");
        gLCD->drawstring(115, 1, buff);
    }
    
    void drawSequencePattern() {
        char buff[32];
        sprintf(buff, "%02d", this->getSequencePattern() + 1);
        gLCD->drawstring(115, 2, "PT");
        gLCD->drawstring(115, 3, buff);
    }
    
    void drawWaveShape() {
        char *str;
        if (this->getWaveShape() == 0) {
            str = "SQ";
        } else {
            str = "SW";
        }
        gLCD->drawstring(115, 5, str);
    }
    
    virtual void displayWhileStop(int editingStep, int runningStep) {
        gLCD->clear();
        
        drawSequenceGrid(editingStep);
        drawNoteGrid();
        drawRunningStep(runningStep);
        drawOctave();
        drawSequencePattern();
        drawWaveShape();

        gLCD->display();
    };
    
    virtual void displayWhileRun(int editingStep, int runningStep) {
        displayWhileStop(editingStep, runningStep);
        /*
        gLCD->clear();
        
        drawSequenceGrid(editingStep);
        drawNoteGrid();
        drawRunningStep(runningStep);
        drawOctave();
        drawSequencePattern();
        drawWaveShape();
        
        gLCD->display();
        */
    }
    /*
    void displayParams(int step) {
        char buff[64];
        gLCD->clear(); 
        sprintf(buff, "Step: %d", step);
        gLCD->drawstring(0, 0, buff);
        sprintf(buff, "Pitch: %d", sequences[step].getPitch());
        gLCD->drawstring(0, 1, buff);
        sprintf(buff, "BPM: %d", this->getBpm());
        gLCD->drawstring(0, 2, buff);
        gLCD->display();
    };
    */
    
private:
    ST7565* gLCD;
    int runningStep;

};

#endif  //ST7565_SEQUENCE_DISPLAY_H_
