
/*
 * SequencerDisplay.h
 *
 * 2016.08.13
 *
 */
#ifndef _SEQUENCE_DISPLAY_H_
#define _SEQUENCE_DISPLAY_H_

#include "mbed.h"
#include "Sequence.h"

class SequencerDisplay {
public:
    enum DisplayMode { stop, run };
    
    SequencerDisplay(Sequence* _sequences, int _sequenceNum) :
        sequences(_sequences),
        sequenceNum(_sequenceNum),
        octave(0),
        bpm(120),
        waveShape(0),
        sequencePattern(0),
        modNumber(0) {};
    
    void update(enum DisplayMode mode, int editingStep, int runningStep) {
        switch (mode) {
        case run:
            displayWhileRun(editingStep, runningStep);
            break;
        case stop:
            displayWhileStop(editingStep, runningStep);
            break;
        default:
            error("SequenceDisplay::update: invalid mode");
        };
    };
    
    void setSequences(Sequence* _sequences) { sequences = _sequences; }
    Sequence* getSequences() { return sequences; }
    
    void setOctave(int _octave) { octave = _octave; };
    int getOctave() { return octave; };
    
    void setBpm(int _bpm) { bpm = _bpm; };
    int getBpm() { return bpm; };
    
    void setWaveShape(int _waveShape) { waveShape = _waveShape; }
    int getWaveShape() { return waveShape; }
    
    void setModNumber(int _modNumber) { modNumber = _modNumber; }
    int getModNumber() { return modNumber; }
    
    void setSequencePattern(int _sequencePattern) { sequencePattern = _sequencePattern; }
    int getSequencePattern() { return sequencePattern; }
    
protected:
    virtual void displayWhileRun(int editingStep, int runningStep) {
        #if (UART_TRACE)
        printf("displayWhileRun step:%d %d\r\n", editingStep, runningStep);
        #endif
    };
    
    virtual void displayWhileStop(int editingStep, int runningStep) {
        #if (UART_TRACE)
        printf("displayWhileStop step:%d %d\r\n", editingStep, runningStep);
        #endif
    };
    
    Sequence* sequences;
    int sequenceNum;
    int octave;
    int bpm;
    int waveShape;
    int sequencePattern;
    int modNumber;
};

#endif  //_SEQUENCE_DISPLAY_H_