/*
 * SDFileSystem Test
 * 
 * Library
 * SDFileSystem: https://developer.mbed.org/users/neilt6/code/SDFileSystem/ Revision:26
 * mbed: Revision: 124
 *
 * 2016.11.22 created
 *
 */

#include "mbed.h"
#include "SDFileSystem.h"

//Create an SDFileSystem object
SDFileSystem sd(D11, D12, D13, D10, "sd");

int main()
{
    //Mount the filesystem
    sd.mount();

    //Perform a write test
    printf("\nWriting to SD card...");
    FILE *fp = fopen("/sd/sdtest.txt", "w");
    if (fp != NULL) {
        fprintf(fp, "We're writing to an SD card!");
        fclose(fp);
        printf("success!\n");
    } else {
        printf("failed!\n");
    }

    //Perform a read test
    printf("Reading from SD card...");
    fp = fopen("/sd/sdtest.txt", "r");
    if (fp != NULL) {
        char c = fgetc(fp);
        if (c == 'W')
            printf("success!\n");
        else
            printf("incorrect char (%c)!\n", c);
        fclose(fp);
    } else {
        printf("failed!\n");
    }

    //Unmount the filesystem
    sd.unmount();
}