#include "mbed.h"
#include "RotaryEncoder.h"

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led1(LED1);

//RotaryEncoder(PinName pin1_name, PinName pin2_name, int min = 0, int max = 100, int val = 50);
RotaryEncoder re1(D2, D3, 0, 8, 4);
RotaryEncoder re2(D4, D5, -8, 0, -4);

// main() runs in its own thread in the OS
int main() {
    pc.printf("Rotary Encoder Test\r\n");
    
    re1.setInterval(2000);
    re2.setInterval(2000);
    
    pc.printf("re1: min=%d max=%d interval=%d\r\n", re1.getMin(), re1.getMax(), re1.getInterval());
    pc.printf("re2: min=%d max=%d interval=%d\r\n", re2.getMin(), re2.getMax(), re2.getInterval());

    while (true) {
        pc.printf("%d\t%d\r\n", re1.getVal(), re2.getVal());
        led1 = !led1;
        wait(0.1);
    }
}

