/*
 * BaseMachine SpiOscController
 *
 * mbed Rev 135 / mbed-rtos Rev 123
 * 
 * 2017.02.13
 *
 */
#ifndef _SPI_OSC_CONTROLLER_H_
#define _SPI_OSC_CONTROLLER_H_

#include "mbed.h"
#include "OscController.h"

#define DCO_PACKET_HEADER   (0x55)
#define SPI_WAIT            (wait_us(1))

class SpiOscController : public OscController {
public:
    SpiOscController(SPI* _pSpim, PinName _DcoCS, uint8_t _waveShape=WAVESHAPE_SQUARE, uint8_t _pulseWidth=127) :
        OscController(_waveShape, _pulseWidth),
        pSpiM(_pSpim),
        DcoCS(_DcoCS, 1) {}
        
    virtual void outDco()
    {
        #if(UART_TRACE)
        OscController::outDco();
        printf("%d\t", DCO_PACKET_HEADER);
        printf("%d\t", waveShape);
        printf("%d\t", pulseWidth);
        printf("%d\t", frequency10 >> 8);
        printf("%d\t", frequency10 & 0xff);
        printf("\r\n");
        #endif
        
        DcoCS = 0;
        pSpiM->write(DCO_PACKET_HEADER);
        pSpiM->write(waveShape);
        pSpiM->write(pulseWidth);
        pSpiM->write(frequency10 >> 8);
        pSpiM->write(frequency10 & 0xff);
        //SPI_WAIT;
        DcoCS = 1;
    }
    
private:
    SPI* pSpiM;
    DigitalOut DcoCS;
};

#endif //_SPI_OSC_CONTROLLER_H_
