/*
 * BaseMachine_OscController
 *
 * mbed Rev 135 / mbed-rtos Rev 123
 * 
 * 2017.02.13
 *
 */
 
 class OscController {
 public:
    enum WaveShape { WAVESHAPE_SQUARE, WAVESHAPE_SAW, WAVESHAPE_N, WAVESHAPE_OFF=0xff };
    
    OscController(uint8_t _waveShape=WAVESHAPE_SQUARE, uint8_t _pulseWidth=127) :
        waveShape(_waveShape),
        pulseWidth(_pulseWidth) {}
        
    virtual void outDco()
    {
        printf("%d\t%d\t%d\r\n", frequency10, waveShape, pulseWidth);
    }

    // frequecny10: 周波数の10倍値を16bit左シフト
    void setFrequency10(uint16_t _frequency10)
    {
        frequency10 = _frequency10;        
    }
    
    void setWaveShape(uint8_t _waveShape) {
        if (_waveShape < WAVESHAPE_N) {
            waveShape = _waveShape;
        }
    }
    
    uint8_t getWaveShape() {
        return waveShape;
    }
    
    void setPulseWidth(uint8_t _pulseWidth) {
        pulseWidth = _pulseWidth;
    }
    
    uint8_t getPulseWidth() {
        return pulseWidth;
    }

protected:
    uint16_t frequency10;
    uint8_t waveShape;
    uint8_t pulseWidth;
};
