#include "mbed.h"

/*
// Nucleo F303
AnalogOut my_output1(A5);
AnalogOut my_output2(A4);
AnalogOut my_output3(A3);
*/

// Nucleo F446/F767
AnalogOut my_output1(PA_4);
AnalogOut my_output2(PA_5);

#define PI        (3.141592653589793238462)
#define AMPLITUDE (0.8)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)

// Configuration for wave output
#define BUFFER_SIZE (360)
uint16_t buffer_sine[BUFFER_SIZE];
uint16_t buffer_cosine[BUFFER_SIZE];
uint16_t buffer_saw[BUFFER_SIZE];

void calculate_sinewave(void);
void calculate_cosinewave(void);
void calculate_sawwave(void);

int main() {
    printf("Multi-channel DAC example\n");
    calculate_sinewave();
    calculate_cosinewave();
    calculate_sawwave();
    while(1) {      
        // wave output
        for (int i = 0; i < BUFFER_SIZE; i++) {
            my_output1.write_u16(buffer_sine[i]);
            my_output2.write_u16(buffer_cosine[i]);
            //my_output3.write_u16(buffer_saw[i]);
        }
    }
}

// Create the wave buffer
void calculate_sinewave(void){
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * i)/180.0; // Convert degree in radian
     buffer_sine[i] = (uint16_t)(AMPLITUDE * (RANGE * (sin(rads + PHASE))) + OFFSET);
  }
}

void calculate_cosinewave(void) {
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * i)/180.0; // Convert degree in radian
     buffer_cosine[i] = (uint16_t)(AMPLITUDE * (RANGE * (cos(rads + PHASE))) + OFFSET);
  }
}

void calculate_sawwave(void) {
    for (int i = 0; i < BUFFER_SIZE; i++) {
        buffer_saw[i] = i * 0xFFFF / BUFFER_SIZE;
    }
}
