/*
 * SPI Slave Test for BaseMachine UI Controller
 *
 * 2016.10.02
 *
 */

#include "mbed.h"
#include "rtos.h"
#include "SPISlave.h"

#define SPI_SPEED   (10000000)

BusOut Leds(PA_10, PB_3, PB_5, PB_4, PB_10, PA_8);
//DigitalOut StepChangePin(PC_7);
DigitalOut StepChangePin(PB_1);

//SPISlave SpiS(PA_7, PA_6, PA_5, PA_4);    // mosi, miso, sclk, ssel
// SPI2
SPISlave SpiS(PB_15, PB_14, PB_13, PB_12);    // mosi, miso, sclk, ssel

unsigned int step = 0;

void stepUp(void const* arg)
{
    step++;
    
    // Slaveにinterruptをかける。
    StepChangePin.write(1);
    StepChangePin.write(0);
}

int main()
{
    printf("\r\n\nNucleo rtos SPISlave Test..\r\n");
    
    // Setup LED
    for (int i = 0; i < 5; i++) {
        Leds.write(0x3f);
        Thread::wait(100);
        Leds.write(0x00);
        Thread::wait(100);
    }

    // Setup SPISlave
    SpiS.format(8, 0);
    SpiS.frequency(SPI_SPEED);

    // RtosTimer
    RtosTimer stepTimer(stepUp, osTimerPeriodic, (void *)0);
    stepTimer.start(125);   // BPM:120
    
    SpiS.reply(0);
    while(1) {
        if(SpiS.receive()) {
            int v = SpiS.read();   // Read byte from master
            Leds.write(v);
            SpiS.reply(step % 16);
        }
    }
}
