/*
 * aitendo 4x4 keypad Test
 *
 * 2016.10.04
 *
 */
#include "mbed.h"
#include "rtos.h"

const char keypadChar [] = {
  'C', 'D', 'E', 'F',
  '9', '0', 'A', 'B',
  '5', '6', '7', '8',
  '1', '2', '3', '4',  
};

BusIn KeypadIn(PA_13, PA_14, PA_15, PB_7);
BusOut KeypadOut(PC_13, PA_9, PA_8, PB_10);

//------------------------------------------------------
// keyScan1(): 押されているキー
// return: キースキャンの結果 0..15
//         押されていない場合は -1
//------------------------------------------------------
int keyScan1()
{
  int i, j;
  for (i = 0; i < 4; i++) {
    KeypadOut[i] = 1;
    for (j = 0; j < 4; j++) {
      if (KeypadIn[j] == 1) {
        KeypadOut[i] = 0;
        return i * 4 + j;
      }
    }
    KeypadOut[i] = 0;
  }
  return -1;
}

//------------------------------------------------------
// keyScan(): 押して離されたキー
// return: キースキャンの結果 0..15
//         変化がない場合は -1
//------------------------------------------------------
int keyScan()
{
    static int keyBuff;
    int kv, kvv;

    // チャタリング防止
    kv = keyScan1();
    Thread::wait(10);
    kvv = keyScan1();

    if (kv == kvv) {
        if (kv != keyBuff) {
            keyBuff = kv;
            return kv;
        }
    }
    return -1;
}
    
int main()
{
    printf("\r\n\r\n*** RTOS 4x4 Keypad Test ***\r\n");
    
    KeypadIn.mode(PullDown);
    
    for (int i = 0; i < 4; i++) {
        KeypadOut[i] = 0;
    }
    
    while (true) {
        int v = keyScan();
        if (v != -1) {
            printf("%c", keypadChar[v]);
        }
    }
}
