#include "mbed.h"
#include "rtos.h"

class TestClass
{
public:
    TestClass(const char* _instanceName, uint32_t _updateTime) :
        updateTime(_updateTime),
        timer(&TestClass::threadHelper, osTimerPeriodic, (void *)this)
    {
        //NOTE: The RTOS hasn't started yet, so we can't create the internal thread here
        strncpy(instanceName, _instanceName, 20);
    }

    void run() {
        timer.start(updateTime);
    }

    void stop() {
        timer.stop();
    }

private:
    char instanceName[20];
    uint32_t updateTime;
    RtosTimer timer;

    static void threadHelper(const void* arg) {
        printf("In threadHelper()\r\n");

        //Cast the argument to a TestClass instance pointer
        TestClass* instance = (TestClass*)arg;

        //Call the thread method for the TestClass instance
        instance ->threadMethod();
    }

    void threadMethod() {
        printf("In threadMethod()\t%s\r\n", instanceName);
    }
};

int main()
{
    printf("\n\n\r** Using An RtosTimer inside a class test **\r\n");
    
    while (true) {
        printf("In main loop\r\n");
        TestClass test1("test1", 1000);
        TestClass test2("test2", 500);
        test1.run();
        test2.run();
        Thread::wait(10000);
        /*
        test1.stop();
        test2.stop();
        */
    }
}
