#include "mbed.h"
#include "mcp3208.h"

#define SAMPLING_RATE   (96000)
#define SAMPLING_PERIOD (1.0f/SAMPLING_RATE)

DigitalOut checkPin(D2);

void isr()
{
    checkPin = 1;
    wait_us(1);
    checkPin = 0;
}

int main()
{
    SPI spiM(SPI_MOSI, SPI_MISO, SPI_SCK);
    spiM.frequency(4000000);
    MCP3208 mcp3208_0(spiM, D10);
    MCP3208 mcp3208_1(spiM, D9);
    
    float v0[8];
    float v1[8];
    
    Ticker t;
    t.attach(&isr, SAMPLING_PERIOD);

    for (;;) {
        for (int i = 0; i < 8; i++) {
            v0[i] = mcp3208_0.read_input(i);
        }        
        for (int i = 0; i < 8; i++) {
            v1[i] = mcp3208_1.read_input(i);
        }
        
        printf("Device0\t");
        for (int i = 0; i < 8; i++) {
            printf("%.3f\t", v0[i]);
        }
        printf("\r\n");
        printf("Device1\t");
        for (int i = 0; i < 8; i++) {
            printf("%.3f\t", v1[i]);
        }
        printf("\r\n");
        
        wait(0.2);
    }
}
