#include "mbed.h"
#include "mcp3208.h"

int main()
{
    SPI spiM(SPI_MOSI, SPI_MISO, SPI_SCK);
    spiM.frequency(2000000);
    MCP3208 mcp3208_0(spiM, D10);
    MCP3208 mcp3208_1(spiM, D9);
    
    DigitalOut checkPin(D2);
    
    float v0[8];
    float v1[8];

    for (;;) {
        for (int i = 0; i < 8; i++) {
            checkPin = 1;
            v0[i] = mcp3208_0.read_input(i);
            checkPin = 0;
            wait_us(1);
        }        
        for (int i = 0; i < 8; i++) {
            checkPin = 1;
            v1[i] = mcp3208_1.read_input(i);
            checkPin = 0;
            wait_us(1);
        }
        
        printf("Device0\t");
        for (int i = 0; i < 8; i++) {
            printf("%.3f\t", v0[i]);
        }
        printf("\r\n");
        printf("Device1\t");
        for (int i = 0; i < 8; i++) {
            printf("%.3f\t", v1[i]);
        }
        printf("\r\n");
        
        wait(0.2);
    }
}
