#include "mbed.h"
#include "mcp3008.h"

#define UART_TRACE  0
#define UART_CSV_DEVICE0    0
#define UART_CSV_DEVICE1    1

#define SAMPLING_RATE   (48000)
#define SAMPLING_PERIOD (1.0f/SAMPLING_RATE)

DigitalOut checkPin(D2);

void isr()
{
    checkPin = 1;
    wait_us(1);
    checkPin = 0;
}

int main()
{
    SPI spiM(SPI_MOSI, SPI_MISO, SPI_SCK);
    spiM.frequency(4000000);
    MCP3008 mcp3008_0(spiM, D10);
    MCP3008 mcp3008_1(spiM, D9);
    
    float vf0[8];
    float vf1[8];
    
    uint16_t vi0[8];
    uint16_t vi1[8];
    
    Ticker t;
    t.attach(&isr, SAMPLING_PERIOD);

    for (;;) {
        for (int i = 0; i < 8; i++) {
            vf0[i] = mcp3008_0.read_input(i);
            vi0[i] = mcp3008_0.read_input_u16(i);
        }        
        for (int i = 0; i < 8; i++) {
            vf1[i] = mcp3008_1.read_input(i);
            vi1[i] = mcp3008_1.read_input_u16(i);
        }        
        
#if UART_TRACE
        printf("Device0\t");
        for (int i = 0; i < 8; i++) {
            printf("%0.3f(%4d)\t", vf0[i], vi0[i]);
        }
        printf("\r\n");
        printf("Device1\t");
        for (int i = 0; i < 8; i++) {
            printf("%0.3f(%4d)\t", vf1[i], vi1[i]);
        }
        printf("\r\n");
#elif UART_CSV_DEVICE0
        for (int i = 0; i < 8; i++) {
            printf("%4d,", vi0[i]);
        }
        printf("\r\n");
#elif UART_CSV_DEVICE1
        for (int i = 0; i < 8; i++) {
            printf("%4d,", vi1[i]);
        }
        printf("\r\n");
#endif
        
        wait(0.1);
    }
}
 