#include "mbed.h"
#include "mcp3008.h"

#define SPI_CLOCK   (1312500)

//SPI (PinName mosi, PinName miso, PinName sclk, PinName ssel=NC)
SPI spiM(D4, D5, D3);
MCP3008 mcp3008_0(&spiM, D6);
MCP3008 mcp3008_1(&spiM, D7);
MCP3008 mcp3008_2(&spiM, D8);

int main()
{
    spiM.frequency(SPI_CLOCK);
    
    uint16_t v0[8];
    uint16_t v1[8];
    uint16_t v2[8];

    for (;;) {
        for (int i = 0; i < 8; i++) {
            v0[i] = mcp3008_0.read_input_u16(i);
            v1[i] = mcp3008_1.read_input_u16(i);
            v2[i] = mcp3008_2.read_input_u16(i);
        }        
        
        for (int i = 0; i < 8; i++) {
            printf("%4d\t", v0[i]);
        }
        
        printf(": ");
        for (int i = 0; i < 8; i++) {
            printf("%4d\t", v1[i]);
        }
        
        printf(": ");
        for (int i = 0; i < 8; i++) {
            printf("%4d\t", v2[i]);
        }
        
        printf("\r\n");
        
        wait(0.2);
    }
}
 