/*
 * MCP23S17 Test
 *
 * MCP23S17 Library:
 * https://developer.mbed.org/users/stjo2809/code/MCP23S17/
 *
 * mbed:  rev 121
 * mbed-rtos: rev 117
 *
 * Created: 2016.10.28
 *
 */

#include "mbed.h"
#include "rtos.h"
#include "MCP23S17.h"

SPI Spi(PC_12, PC_11, PC_10); // SPI3: mosi, miso, sclk
//SPI Spi(PA_7, PA_6, PA_5); // SPI1:  mosi, miso, sclk

InterruptIn Mcp23s17Int(PA_14);

// MCP23S17(int hardwareaddress, SPI& spi, PinName nCs, PinName nReset);
MCP23S17 Mcp23s17(0x00, Spi, PD_2, PA_13);

void dataChanged()
{
    char data = Mcp23s17.intcapb();
    wait_us(1);
    Mcp23s17.gpioa(data);
}

int main()
{
    printf("\r\n\n*** MCP23S17 Test ***\r\n");

    // Reset MCP23S17
    Mcp23s17.reset();
    
    // PORTA output
    Mcp23s17.iodira(0x00);

    // PORTB input
    Mcp23s17.iodirb(0xFF);
    // PORTB pull-up
    Mcp23s17.gppub(0xFF);
    // PORTB invert polarity
    Mcp23s17.ipolb(0xFF);
    // PORTB enable on change interrupt
    Mcp23s17.gpintenb(0xFF);
    
    // Attach the callback function
    Mcp23s17Int.rise(&dataChanged);
    
    // LED Check
    for (int i = 0; i < 8; i++) {
        Mcp23s17.gpioa(1 << i);
        wait(0.1);
    }
    Mcp23s17.gpioa(0x00);
    
    while (true) {
    }
}

