#include "mbed.h"
#include "EnvelopeADSR.h"

#define TITLE_STR1  ("Nucleo F446 EG")
#define TITLE_STR2  ("2018.06.28")

// Internal DAC
AnalogOut Aout0(PA_4);

// ADSR POT
AnalogIn Ain0(PC_2);
AnalogIn Ain1(PC_3);
AnalogIn Ain2(PC_1);
AnalogIn Ain3(PC_0);
AnalogIn Ain4(PB_0);
AnalogIn Ain5(PA_1);
AnalogIn Ain6(PA_0);
AnalogIn Ain7(PC_4);

// Envelope
EnvelopeADSR envelope;
const int sampleMagnify = 10000;  // POTの読み取り値が1.0fの場合のA/D/Rの値

// Gate
InterruptIn gateIn(USER_BUTTON);

void gateInterruptRise() {
    envelope.gateOff();
}

void gateInterruptFall() {
    envelope.gateOn();
}

int main()
{
    printf("\r\n%s %s \r\n", TITLE_STR1, TITLE_STR2);
    
    gateIn.rise(&gateInterruptRise);
    gateIn.fall(&gateInterruptFall);

    while(1) {
        float a0 = Ain0.read();
        float a1 = Ain1.read();
        float a2 = Ain2.read();
        float a3 = Ain3.read();
        float a4 = Ain4.read();
        float a5 = Ain5.read();
        float a6 = Ain6.read();
        float a7 = Ain7.read();
        
        // Envelope 1
        int a = a0 * sampleMagnify;
        int d = a1 * sampleMagnify;
        float s = a2;
        int r = a3 * sampleMagnify;
        
        envelope.setADSR(a, d, s, r);
        float amplitude = envelope.tick();
        
        Aout0.write(amplitude);
        
        /*        
        printf("%.4f\t%.2f\t%.2f\t%.2f\t%.2f\t\r\n",
             amplitude, a0, a1, a2, a3);
        */

    }
}
