#include "mbed.h"

AnalogOut aout(A2);

const int maxAoutValue = 4096;
const float samplingPeriod = 0.25f / maxAoutValue;

int cnt = 0;

void tick()
{
    cnt++;
    if (cnt == maxAoutValue) {
        cnt = 0;
    }
    aout.write_u16(cnt << 4);
}

int main()
{
    Ticker t;
    t.attach(&tick, samplingPeriod);

    for (;;) {}
}
