#include "mbed.h"
#include "MIDI.h"

#define TITLE_STR1  ("MIDI Message")
#define TITLE_STR2  ("20180502")

MIDI midi(D10, D2); // Serail2
Serial pc(D1, D0);  // Serial1

// -----------------------------------------------------------------------------

void printNoteOnOff(const char* type, byte inChannel, byte inNote, byte inVelocity) 
{
    pc.printf("%s %3d %3d %3d\r\n", type, inChannel, inNote, inVelocity);
}

void handleNoteOn(byte inChannel, byte inNote, byte inVelocity)
{
    midi.sendNoteOn(inNote, inVelocity, inChannel);
    printNoteOnOff("On ", inChannel, inNote, inVelocity);
}

void handleNoteOff(byte inChannel, byte inNote, byte inVelocity)
{
    midi.sendNoteOff(inNote, inVelocity, inChannel);
    printNoteOnOff("Off", inChannel, inNote, inVelocity);
}

// -----------------------------------------------------------------------------

int main()
{
    midi.setHandleNoteOn(handleNoteOn);
    midi.setHandleNoteOff(handleNoteOff);
    midi.begin(MIDI_CHANNEL_OMNI);
    
    pc.baud(115200);

    for (;;) {
        if (midi.read()) {
            byte type    = midi.getType();
            byte channel = midi.getChannel(); 
            byte data1   = midi.getData1();
            byte data2   = midi.getData2();
    
            pc.printf("%2x %2x %2x %2x\r\n", type, channel, data1, data2);
        }
    }
}
