/*
 * AR Type Envelope Class
 *
 * 2017.09.18
 *
 */

#ifndef _ENVELOPE_AR_H_
#define _ENVELOPE_AR_H_

class EnvelopeParam
{
public:
    int attack;
    int release;
    float v0;
    float v1;
    float v2;
    float attackTauRatio;
    float releaseTauRatio;
};

class EnvelopeAR
{
public:
    EnvelopeAR(int _attack, int _release, float _v0, float _v1, float _v2, float _attackTauRatio=0.36f, float _releaseTauRatio=0.36f) :
        amplitude(_v0),
        v0(_v0),
        v1(_v1),
        v2(_v2),
        attackTauRatio(_attackTauRatio),
        releaseTauRatio(_releaseTauRatio)
    {
        setAttack(_attack);
        setRelease(_release);
    }

    EnvelopeAR(const EnvelopeParam& param) :
        amplitude(param.v0),
        v0(param.v0),
        v1(param.v1),
        v2(param.v2),
        attackTauRatio(param.attackTauRatio),
        releaseTauRatio(param.releaseTauRatio)
    {
        setAttack(param.attack);
        setRelease(param.release);
    }

    ~EnvelopeAR() {}

    void setAttack(int _attack) {
        attack = _attack;
        tau0 = attack * attackTauRatio;
    }
    int getAttack() {
        return attack;
    }

    void setRelease(int _release) {
        release = _release;
        tau1 = release * releaseTauRatio;
    }
    int getRelease() {
        return release;
    }

    void setAttackTauRatio(float _attackTauRatio) {
        attackTauRatio = _attackTauRatio;
        tau0 = attack * attackTauRatio;
    }
    float getAttackTauRatio() {
        return attackTauRatio;
    }

    void setReleaseTauRatio(float _releaseTauRatio) {
        releaseTauRatio = _releaseTauRatio;
        tau1 = release * releaseTauRatio;
    }
    float getReleaseTauRatio() {
        return releaseTauRatio;
    }

    float getTau0() {
        return tau0;
    }
    float getTau1() {
        return tau1;
    }

    void setV0(float _v0) {
        v0 = _v0;
    }
    float getV0() {
        return v0;
    }
    void setV1(float _v1) {
        v1 = _v1;
    }
    float getV1() {
        return v1;
    }
    void setV2(float _v2) {
        v2 = _v2;
    }
    float getV2() {
        return v2;
    }

    float getAmplitude() {
        return amplitude;
    }
    
    void setParam(const EnvelopeParam& param) {
        setV0(param.v0);
        setV1(param.v1);
        setV2(param.v2);
        setAttackTauRatio(param.attackTauRatio);
        setReleaseTauRatio(param.releaseTauRatio);
        setAttack(param.attack);
        setRelease(param.release);
    }

    float getAmplitude(int tick) {
        if (tick <= attack) {
            // attackの処理
            amplitude = v0 + (v1 - v0) * (1 - expf(-(float)tick / tau0));
        } else {
            // releaseの処理
            float vAttack = v0 + (v1 - v0) * (1 - expf(-attack / tau0));
            amplitude = (vAttack - v2) * (expf(-(float)(tick - attack) / tau1)) + v2;
        }
        return amplitude;
    }

private:
    int attack;
    int release;
    float amplitude;
    float v0;
    float v1;
    float v2;
    float tau0;
    float tau1;
    float attackTauRatio;
    float releaseTauRatio;
};

#endif //_ENVELOPE_AR_H_
