#include "mbed.h"
#include "rtos.h"

#include "ExioMcp23s17PinDetect.h"
#include "ExioMcp23s17DebounceIn.h"
#include "ExioMcp23s17RotaryEncoder.h"
#include "ExioMcp23s17Keypad4x4.h"

SPI Spi(PC_12, PC_11, PC_10); // SPI3: mosi, miso, sclk
//SPI Spi(PA_7, PA_6, PA_5); // SPI1:  mosi, miso, sclk

// MExioMcp23s17(int hardwareaddress, SPI& spi, PinName nCs, PinName nReset);
ExioMcp23s17 Exio(0x00, Spi, PD_2, PA_13);

bool state = false;
uint8_t count = 0;

// トグル動作
void pa6Falled() {
    state = !state;
}

// インクリメント
void pa7Falled() {
    count++;
}

int main()
{
    printf("\r\n\n*** ExioMcp23s17Controller test ***\r\n");
    
    Exio.reset();
    
    // set PORTA[6:7] as PinDetects
    ExioMcp23s17PinDetect PinA6(&Exio, ExioPortA, 6);
    ExioMcp23s17PinDetect PinA7(&Exio, ExioPortA, 7);
    
    // assign callback functions
    PinA6.attach_asserted(&pa6Falled);
    PinA6.setAssertValue(0);
    
    PinA7.attach_asserted(&pa7Falled);
    PinA7.setAssertValue(0);
    
    // set PORTA[4:5] as DebounceIn
    ExioMcp23s17DebounceIn PinA4(&Exio, ExioPortA, 4);
    ExioMcp23s17DebounceIn PinA5(&Exio, ExioPortA, 5);
    PinA4.mode(PullUp);
    PinA5.mode(PullUp);
    
    // set PORTA[0:1], PORTA[2:3] as a Rotary Encoder
    //    ExioMcp23s17RotaryEncoder(
    //    ExioMcp23s17& device, ExioPort port, int pin1, int pin2,
    //    int min = 0, int max = 100, int val = 50
    //);
    ExioMcp23s17RotaryEncoder RotEnc1(&Exio, ExioPortA, 0, 1, 0, 100, 50);
    ExioMcp23s17RotaryEncoder RotEnc2(&Exio, ExioPortA, 2, 3, 0, 100, 50);

    // set PORTB[0:7] as keypad
    ExioMcp23s17Keypad4x4 keypad(&Exio, ExioPortB);
    
    // Start Tickers
    PinA6.setSampleFrequency(10000);
    PinA7.setSampleFrequency(10000);
    PinA4.set_debounce_us(10000);
    PinA5.set_debounce_us(10000);
    RotEnc1.setInterval(1000);
    RotEnc2.setInterval(1000);
    keypad.setSampleFrequency(10000);
  
    while (true) {
        int pinVal1, pinVal2, reVal1, reVal2, kpVal;
        pinVal1 = PinA4.read();
        pinVal2 = PinA5.read();
        reVal1 = RotEnc1.getVal();
        reVal2 = RotEnc2.getVal();
        kpVal = keypad.read();
        printf("state:%d count:%d v1:%d v2:%d RE1:%d RE2:%d KP:%d\r\n", state, count, pinVal1, pinVal2, reVal1, reVal2, kpVal);

        Thread::wait(1);
    }
    
    //delete[] psw;
}
