/*
 * MCP23S17 Keypad 4x4 class
 *
 * 2016.11.02 created
 */
 
#ifndef _EXIOMCP23S17Keypad4x4_
#define _EXIOMCP23S17Keypad4x4_

#include "mbed.h"
#include "ExioMcp23s17.h"

#define IO_DIRECTION (0b11110000)
#define IO_PULLUP    (0b00000000)
#define IO_POLARITY  (0b00000000)

class ExioMcp23s17Keypad4x4 {
public:
    ExioMcp23s17Keypad4x4(ExioMcp23s17* _pDevice, ExioPort _port) :
        pDevice(_pDevice),
        port(_port),
        keyVal(-1),
        keyBuffer(-1)
    {
        pDevice->ioDirection(port, IO_DIRECTION);
        pDevice->ioPullup(port, IO_PULLUP);
        pDevice->ioPolarity(port, IO_POLARITY);
        pDevice->writePort(port, 0x00);
    }
    
    ~ExioMcp23s17Keypad4x4() 
    {
    }
    
    void setSampleFrequency(int i) { ticker.attach_us(this, &ExioMcp23s17Keypad4x4::callback, i); }
    
    int read() { return keyVal; }
    
private:
    //------------------------------------------------------
    // keyScan1(): 押されているキー
    // return: キースキャンの結果 0..15
    //         押されていない場合は -1
    //------------------------------------------------------
    int keyScan1()
    {
      uint8_t data;
      for (int i = 0; i < 4; i++) {
        pDevice->bit(GPIOA_ADDR + port, i + 1, 1);
        data = pDevice->readPort(port);
        pDevice->bit(GPIOA_ADDR + port, i + 1, 0);
        uint8_t rv = data >> 4;
        if (rv) {
            uint8_t lv = 0;
            if      (rv & 0b0001)   lv = 0;
            else if (rv & 0b0010)   lv = 1;
            else if (rv & 0b0100)   lv = 2;
            else if (rv & 0b1000)   lv = 3;

            return (i << 2) | lv;
        }
      }
      return -1;
    }
    
    // The Ticker callback function
    void callback()
    {
        //チャタリング防止
        int v = keyScan1();
        if (v == keyBuffer) {
            keyVal = v;
        }
        keyBuffer = v;
    }
    
    Ticker ticker;
    ExioMcp23s17* pDevice;
    ExioPort port;
    int keyVal;
    int keyBuffer;
};

#endif //_MCP23S17Keypad4x4_
