/*
 * ExioMcp23s17DigitalIn.h
 *
 * Created: 2016.10.30
 *
 */
 
#ifndef _EXIOMCP2317SDIGITALIN_H_
#define _EXIOMCP2317SDIGITALIN_H_

#include "mbed.h"
#include "ExioMcp23s17.h"

class ExioMcp23s17DigitalIn {
public:
    ExioMcp23s17DigitalIn(ExioMcp23s17* _pDevice, ExioPort _port, int _pin) : 
        pDevice(_pDevice),
        port(_port),
        pin(_pin)
    {
        // set as input
        uint8_t tmp = pDevice->ioDirection(port);
        pDevice->ioDirection(port, tmp | (1 << pin));
    }
    
    void mode(PinMode pull)
    {
        uint8_t tmp = pDevice->ioPullup(port);
        switch (pull) {
        case PullUp:
            pDevice->ioPullup(port, tmp | (1 << pin));
            break;
        case PullNone:
            pDevice->ioPullup(port, tmp & ~(1 << pin));
            break;
        default:
            error("PinMode must be PullUp or PullNone");
        }
    }
    
    int read()
    {
        uint8_t data = pDevice->readPort(port);
        int bv = data & (1 << pin);
        return bv ? 1 : 0;
    }
    
protected:
    ExioMcp23s17* pDevice;
    ExioPort port;
    int pin;
};

#endif //_EXIOMCP2317SDIGITALIN_H_
