/*
 * ExioBufferdController Test
 *
 * mbed:      revison 121
 * mbed-rtos: revision 117
 *
 * 2017.01.06 for BaseMachine ExioBoard
 * Created: 2016.11.05
 *
 */
 
#include "mbed.h"
#include "rtos.h"

#include "ExioMcp23s17.h" 
#include "ExioInBuffer.h"
#include "ExioBufferedIn.h"
#include "ExioBufferedDebounceIn.h"
#include "ExioBufferedPinDetect.h"
#include "ExioBufferedRotaryEncoder.h"

SPI Spi(PC_12, PC_11, PC_10); // SPI3: mosi, miso, sclk
//SPI Spi(PA_7, PA_6, PA_5); // SPI1:  mosi, miso, sclk
 
// MExioMcp23s17(int hardwareaddress, SPI& spi, PinName nCs, PinName nReset);
ExioMcp23s17 Exio(0x00, Spi, PD_2, PA_13);
 
bool state = false;
uint8_t count = 0;

//------------------------------------------------------------------------------
// Callback functions
//
void pa6Falled() {
    state = !state;
}

void pa7Falled() {
    count++;
}


//------------------------------------------------------------------------------
// Test functions
//
void testExioInBuffer()
{
    printf("*** Test ExioInBuffer ***\r\n");
    
    // Reset MCP23S17 (初期化時にreset()が必要)
    Exio.reset();

    ExioInBuffer exioInBufferA(&Exio, ExioPortA);
    ExioInBuffer exioInBufferB(&Exio, ExioPortB);
    
    exioInBufferA.run(1);
    exioInBufferB.run(1);
    
    while (true) {
        uint8_t va = exioInBufferA.readPort();
        uint8_t vb = exioInBufferB.readPort();
        
        printf("%d %d\r\n", va, vb);
        //Thread::wait(10);
    }
}

void testExioBufferedIn()
{
    printf("*** Test ExioBuffedIn ***\r\n");
    
    // Reset MCP23S17 (初期化時にreset()が必要)
    Exio.reset();
    
    ExioInBuffer inBufferA(&Exio, ExioPortA);
    ExioBufferedIn inA[] = {
        ExioBufferedIn(&inBufferA, 0),
        ExioBufferedIn(&inBufferA, 1),
        ExioBufferedIn(&inBufferA, 2),
        ExioBufferedIn(&inBufferA, 3),
        ExioBufferedIn(&inBufferA, 4),
        ExioBufferedIn(&inBufferA, 5),
        ExioBufferedIn(&inBufferA, 6),
        ExioBufferedIn(&inBufferA, 7)
    };
    
    ExioInBuffer inBufferB(&Exio, ExioPortB);
    ExioBufferedIn inB[] = {
        ExioBufferedIn(&inBufferB, 0),
        ExioBufferedIn(&inBufferB, 1),
        ExioBufferedIn(&inBufferB, 2),
        ExioBufferedIn(&inBufferB, 3),
        ExioBufferedIn(&inBufferB, 4),
        ExioBufferedIn(&inBufferB, 5),
        ExioBufferedIn(&inBufferB, 6),
        ExioBufferedIn(&inBufferB, 7)
    };
    
    inBufferA.run(10);
    inBufferB.run(10);
    
    while (true) {
        for (int i = 0; i < 8; i++) {
            int va = inA[i].read();
            printf("%d ", va);
        }
        putchar(' ');
        for (int i = 0; i < 8; i++) {
            int vb = inB[i].read();
            printf("%d ", vb);
        }
        printf("\r\n");
        //Thread::wait(10);
    }
}

void testExioBufferedDebounceIn()
{
    printf("*** Test ExioBuffeDebounceIn ***\r\n");
    
    // Reset MCP23S17 (初期化時にreset()が必要)
    Exio.reset();
    
    ExioInBuffer inBufferA(&Exio, ExioPortA);
    ExioBufferedDebounceIn inA[] = {
        ExioBufferedDebounceIn(&inBufferA, 0),
        ExioBufferedDebounceIn(&inBufferA, 1),
        ExioBufferedDebounceIn(&inBufferA, 2),
        ExioBufferedDebounceIn(&inBufferA, 3),
        ExioBufferedDebounceIn(&inBufferA, 4),
        ExioBufferedDebounceIn(&inBufferA, 5),
        ExioBufferedDebounceIn(&inBufferA, 6),
        ExioBufferedDebounceIn(&inBufferA, 7)
    };
    
    ExioInBuffer inBufferB(&Exio, ExioPortB);
    ExioBufferedIn inB[] = {
        ExioBufferedDebounceIn(&inBufferB, 0),
        ExioBufferedDebounceIn(&inBufferB, 1),
        ExioBufferedDebounceIn(&inBufferB, 2),
        ExioBufferedDebounceIn(&inBufferB, 3),
        ExioBufferedDebounceIn(&inBufferB, 4),
        ExioBufferedDebounceIn(&inBufferB, 5),
        ExioBufferedDebounceIn(&inBufferB, 6),
        ExioBufferedDebounceIn(&inBufferB, 7)
    };
    
    // Start Timers
    inBufferA.run(10);
    inBufferB.run(10);
    for (int i = 0; i < 8; i++) {
        inA[i].set_debounce_us(10000);
        inA[i].set_debounce_us(10000);
    }
    
    while (true) {
        for (int i = 0; i < 8; i++) {
            int va = inA[i].read();
            printf("%d ", va);
        }
        putchar(' ');
        for (int i = 0; i < 8; i++) {
            int vb = inB[i].read();
            printf("%d ", vb);
        }
        printf("\r\n");
        //Thread::wait(10);
    }
}

void testExioBufferedPinDetect()
{
    printf("*** Test ExioBufferedPinDetect ***\r\n");
    
    // Reset MCP23S17 (初期化時にreset()が必要)
    Exio.reset();
    
    ExioInBuffer inBufferA(&Exio, ExioPortA);
    ExioBufferedPinDetect pinA6(&inBufferA, 6);
    ExioBufferedPinDetect pinA7(&inBufferA, 7);
    
    // assign callback functions
    pinA6.attach_asserted(&pa6Falled);
    pinA6.setAssertValue(0);
    pinA7.attach_asserted(&pa7Falled);
    pinA7.setAssertValue(0);
    
    // Start Timers
    inBufferA.run(5);
    pinA6.setSampleFrequency(10000);
    pinA7.setSampleFrequency(10000);
            
    while (true) {
        printf("%d %d\r\n", state, count);
    }
}

void testExioBufferedRotaryEncoder()
{
    printf("*** Test ExioBufferedRotaryEncoder ***\r\n");
    
    // Reset MCP23S17 (初期化時にreset()が必要)
    Exio.reset();
    
    ExioInBuffer inBufferA(&Exio, ExioPortA);
    ExioBufferedRotaryEncoder re1(&inBufferA, 0, 1);
    
    // Start Timers
    inBufferA.run(5);
    re1.setInterval(1000);
        
    while (true) {
        int v = re1.getVal();
        printf("%d\r\n", v);
    }
}

int main()
{
    //testExioInBuffer();
    //testExioBufferedIn();
    //testExioBufferedDebounceIn();
    //testExioBufferedRotaryEncoder();
    //testExioBufferedPinDetect();
    
    printf("*** Test ExioBufferedContoroller ***\r\n");
    
    // Reset MCP23S17 (初期化時にreset()が必要)
    Exio.reset();

    // ExioInBuffer
    ExioInBuffer inBufferA(&Exio, ExioPortA);    
    ExioInBuffer inBufferB(&Exio, ExioPortB);

    // PinDetect
    ExioBufferedPinDetect pinA6(&inBufferA, 6);
    ExioBufferedPinDetect pinA7(&inBufferA, 7);
    
    // assign callback functions
    pinA6.attach_asserted(&pa6Falled);
    pinA6.setAssertValue(0);
    pinA7.attach_asserted(&pa7Falled);
    pinA7.setAssertValue(0);
    
    // DebounceIn
    ExioBufferedDebounceIn pinA2(&inBufferA, 2);
    ExioBufferedDebounceIn pinA3(&inBufferA, 3);
    ExioBufferedDebounceIn pinA4(&inBufferA, 4);
    ExioBufferedDebounceIn pinA5(&inBufferA, 5);
    
    ExioBufferedDebounceIn inB[] = {
        ExioBufferedDebounceIn(&inBufferB, 0),
        ExioBufferedDebounceIn(&inBufferB, 1),
        ExioBufferedDebounceIn(&inBufferB, 2),
        ExioBufferedDebounceIn(&inBufferB, 3),
        ExioBufferedDebounceIn(&inBufferB, 4),
        ExioBufferedDebounceIn(&inBufferB, 5),
        ExioBufferedDebounceIn(&inBufferB, 6),
        ExioBufferedDebounceIn(&inBufferB, 7)
    };
    
    // Rotary Encoder
    ExioBufferedRotaryEncoder re1(&inBufferA, 0, 1);
    //ExioBufferedRotaryEncoder re2(&inBufferA, 2, 3);
    
    // Start Timers for polling MCP23S17
    inBufferA.run(5);
    inBufferB.run(10);
    
    // Start Timers for PinDetect
    pinA6.setSampleFrequency(10000);
    pinA7.setSampleFrequency(10000);
    
    // Start Timers for DebounceIn
    pinA2.set_debounce_us(10000);
    pinA3.set_debounce_us(10000);
    pinA4.set_debounce_us(10000);
    pinA5.set_debounce_us(10000);
    for (int i = 0; i < 8; i++) {
        inB[i].set_debounce_us(10000);
    }
    
    // Start Timers for RotaryEncoder
    re1.setInterval(1000);
    //re2.setInterval(1000);

    while(true) {
        int va2 = pinA2.read();
        int va3 = pinA3.read();
        int va4 = pinA4.read();
        int va5 = pinA5.read();
        int vre1 = re1.getVal();
        //int vre2 = re2.getVal();
        printf(" A2:%d A3:%d A4:%d A5:%d state:%d count:%d RE1:%d ", va2, va3, va4, va5, state, count, vre1);
        for (int i = 0; i < 8; i++) {
            int vb = inB[i].read();
            printf("%d ", vb);
        }
        printf("\r\n");
    }
}
