/*
 * ExioMcp23s17.h
 * Rapper Class for MCP23S17
 *
 * Use MCP23S17 Library:
 * https://developer.mbed.org/users/stjo2809/code/MCP23S17/
 *
 * 割込み処理は未実装
 *
 * Created: 2016.10.30
 *
 */
 
#ifndef _EXIOMCP23S17_H_
#define _EXIOMCP23S17_H_

#include "mbed.h"
#include "MCP23S17.h"

typedef enum { ExioPortA, ExioPortB } ExioPort;
    
class ExioMcp23s17 : public MCP23S17 {
public:
    ExioMcp23s17(int hardwareaddress, SPI& spi, PinName nCs, PinName nReset) :
        MCP23S17(hardwareaddress, spi, nCs, nReset) {}
    
    ExioMcp23s17(int hardwareaddress, SPI& spi, PinName nCs) :
        MCP23S17(hardwareaddress, spi, nCs) {}
        
    uint8_t ioDirection(ExioPort port) { return read(IODIRA_ADDR | port); }
    void ioDirection(ExioPort port, uint8_t data) { write(IODIRA_ADDR | port, data); }
    
    uint8_t ioPolarity(ExioPort port) { return read(IPOLA_ADDR | port); }
    void ioPolarity(ExioPort port, uint8_t data) { write(IPOLA_ADDR | port, data); }
    
    uint8_t ioPullup(ExioPort port) { return read(GPPUA_ADDR | port); }
    void ioPullup(ExioPort port, uint8_t data) { write(GPPUA_ADDR | port, data); }
    
    uint8_t readPort(ExioPort port) { return read(GPIOA_ADDR | port); }
    void writePort(ExioPort port, uint8_t data) { write(GPIOA_ADDR | port, data); }

protected:
    void write(uint8_t reg_address, uint8_t data) { MCP23S17::write(reg_address, data); }
    uint8_t read(uint8_t reg_address) { return MCP23S17::read(reg_address); }
};

#endif //_EXIOMCP23S17_H_